/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.handler.impl.ScopedAuthentication;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JWTAuthHandlerImpl
extends HTTPAuthorizationHandler<JWTAuth>
implements JWTAuthHandler,
ScopedAuthentication<JWTAuthHandler> {
    private final List<String> scopes;
    private final String delimiter;

    public JWTAuthHandlerImpl(JWTAuth authProvider, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER, realm);
        this.scopes = new ArrayList<String>();
        this.delimiter = " ";
    }

    private JWTAuthHandlerImpl(JWTAuthHandlerImpl base, List<String> scopes, String delimiter) {
        super(base.authProvider, HTTPAuthorizationHandler.Type.BEARER, base.realm);
        this.scopes = scopes;
        this.delimiter = delimiter;
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        this.parseAuthorization(context, parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            String token = (String)parseAuthorization.result();
            int segments = 0;
            for (int i = 0; i < token.length(); ++i) {
                char c = token.charAt(i);
                if (c == '.') {
                    if (++segments != 3) continue;
                    handler.handle(Future.failedFuture(new HttpException(400, "Too many segments in token")));
                    return;
                }
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                handler.handle(Future.failedFuture(new HttpException(400, "Invalid character in token: " + c)));
                return;
            }
            ((JWTAuth)this.authProvider).authenticate((Credentials)new TokenCredentials(token), authn -> {
                if (authn.failed()) {
                    handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                } else {
                    handler.handle((AsyncResult<User>)authn);
                }
            });
        });
    }

    @Override
    public JWTAuthHandler withScope(String scope) {
        ArrayList<String> updatedScopes = new ArrayList<String>(this.scopes);
        updatedScopes.add(scope);
        return new JWTAuthHandlerImpl(this, updatedScopes, this.delimiter);
    }

    @Override
    public JWTAuthHandler withScopes(List<String> scopes) {
        return new JWTAuthHandlerImpl(this, scopes, this.delimiter);
    }

    @Override
    public JWTAuthHandler scopeDelimiter(String delimeter) {
        return new JWTAuthHandlerImpl(this, this.scopes, delimeter);
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        User user = ctx.user();
        if (user == null) {
            ctx.fail(403, new IllegalStateException("no user in the context"));
            return;
        }
        if (this.scopes.size() > 0) {
            JsonObject jwt = (JsonObject)user.get("accessToken");
            if (jwt == null) {
                ctx.fail(403, new IllegalStateException("Invalid JWT: null"));
                return;
            }
            if (jwt.getValue("scope") == null) {
                ctx.fail(403, new IllegalStateException("Invalid JWT: scope claim is required"));
                return;
            }
            List target = jwt.getValue("scope") instanceof String ? Stream.of(jwt.getString("scope").split(this.delimiter)).collect(Collectors.toList()) : jwt.getJsonArray("scope").getList();
            if (target != null) {
                for (String scope : this.scopes) {
                    if (target.contains(scope)) continue;
                    ctx.fail(403, new IllegalStateException("JWT scopes != handler scopes"));
                    return;
                }
            }
        }
        ctx.next();
    }
}

