/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.emqx;

import cc.iotkit.comp.IMessageHandler;
import cc.iotkit.comp.emqx.EmqxConfig;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(AuthVerticle.class);
    private HttpServer backendServer;
    private IMessageHandler executor;
    private EmqxConfig config;

    public void setExecutor(IMessageHandler executor) {
        this.executor = executor;
    }

    public AuthVerticle(EmqxConfig config) {
        this.config = config;
    }

    @Override
    public void start() throws Exception {
        this.backendServer = this.vertx.createHttpServer();
        Router backendRouter = Router.router(this.vertx);
        backendRouter.route().handler(BodyHandler.create());
        backendRouter.route(HttpMethod.POST, "/mqtt/auth").handler(rc -> {
            String json = rc.getBodyAsString();
            log.info("mqtt auth:{}", (Object)json);
            try {
                HashMap<String, String> head = new HashMap<String, String>();
                head.put("topic", "/mqtt/auth");
                this.executor.onReceive(head, "auth", json);
                rc.response().setStatusCode(200).end();
            }
            catch (Throwable e) {
                rc.response().setStatusCode(500).end();
                log.error("mqtt auth failed", e);
            }
        });
        backendRouter.route(HttpMethod.POST, "/mqtt/acl").handler(rc -> {
            String json = rc.getBodyAsString();
            log.info("mqtt acl:{}", (Object)json);
            try {
                HashMap<String, String> head = new HashMap<String, String>();
                head.put("topic", "/mqtt/acl");
                this.executor.onReceive(head, "acl", json);
                rc.response().setStatusCode(200).end();
            }
            catch (Throwable e) {
                rc.response().setStatusCode(500).end();
                log.error("mqtt acl failed", e);
            }
        });
        this.backendServer.requestHandler(backendRouter).listen(this.config.getAuthPort());
    }

    @Override
    public void stop() throws Exception {
        this.backendServer.close(voidAsyncResult -> log.info("close emqx auth server..."));
    }
}

