/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.analysis;

import cc.iotkit.comp.DLT645.analysis.DLT645DataFormat;
import java.util.Map;

public abstract class DLT645Data {
    private String name;
    private DLT645DataFormat format = new DLT645DataFormat();
    private int length;
    private String unit;
    private boolean read;
    private boolean write;
    private Object value = 0.0;
    private Object value2nd;

    public abstract String getKey();

    public abstract byte[] getDIn();

    public abstract void setDIn(byte[] var1);

    public abstract int getDInLen();

    public String toString() {
        if (this.value2nd == null) {
            return this.name + ":" + this.value + this.unit;
        }
        return this.name + ":" + this.value + this.unit + " " + this.value2nd;
    }

    public void decodeValue(byte[] data, Map<String, DLT645Data> dinMap) {
        this.setDIn(data);
        DLT645Data dict = dinMap.get(this.getKey());
        if (dict == null) {
            throw new RuntimeException("DIn info err,please configure\uff1a" + this.getKey());
        }
        this.format = dict.format;
        this.name = dict.name;
        this.read = dict.read;
        this.write = dict.write;
        this.length = dict.length;
        this.unit = dict.unit;
        this.value = this.format.decodeValue(data, this.format.getFormat(), this.getDInLen(), this.format.getLength());
        if (this.format.getFormat2nd() != null && !this.format.getFormat2nd().isEmpty()) {
            this.value2nd = this.format.decodeValue(data, this.format.getFormat2nd(), this.getDInLen() + this.format.getLength(), this.format.getLength2nd());
        }
    }

    public String getName() {
        return this.name;
    }

    public DLT645DataFormat getFormat() {
        return this.format;
    }

    public int getLength() {
        return this.length;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isWrite() {
        return this.write;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue2nd() {
        return this.value2nd;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFormat(DLT645DataFormat format) {
        this.format = format;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setValue2nd(Object value2nd) {
        this.value2nd = value2nd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DLT645Data)) {
            return false;
        }
        DLT645Data other = (DLT645Data)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.isRead() != other.isRead()) {
            return false;
        }
        if (this.isWrite() != other.isWrite()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DLT645DataFormat this$format = this.getFormat();
        DLT645DataFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Object this$value2nd = this.getValue2nd();
        Object other$value2nd = other.getValue2nd();
        return !(this$value2nd == null ? other$value2nd != null : !this$value2nd.equals(other$value2nd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DLT645Data;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLength();
        result = result * 59 + (this.isRead() ? 79 : 97);
        result = result * 59 + (this.isWrite() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DLT645DataFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Object $value2nd = this.getValue2nd();
        result = result * 59 + ($value2nd == null ? 43 : $value2nd.hashCode());
        return result;
    }
}

