/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.mqtt;

import cc.iotkit.common.thing.ThingService;
import cc.iotkit.common.utils.JsonUtil;
import cc.iotkit.comp.mqtt.IScripter;
import cc.iotkit.comp.mqtt.TransparentMsg;
import cc.iotkit.model.device.message.ThingModelMessage;
import cc.iotkit.model.product.ProductModel;
import java.util.Map;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsScripter
implements IScripter {
    private static final Logger log = LoggerFactory.getLogger(JsScripter.class);
    private ProductModel model;
    private final NashornScriptEngine engine = (NashornScriptEngine)new ScriptEngineManager().getEngineByName("nashorn");
    private Object scriptObj;

    public JsScripter(ProductModel model) {
        this.model = model;
    }

    @Override
    public void setScript(String script) {
        try {
            this.scriptObj = this.engine.eval(String.format("new (function () {\n%s})()", script));
        }
        catch (Throwable e) {
            throw new RuntimeException("init script error", e);
        }
    }

    @Override
    public ThingModelMessage decode(TransparentMsg msg) {
        try {
            ScriptObjectMirror result = (ScriptObjectMirror)this.engine.invokeMethod(this.scriptObj, "decode", new Object[]{msg});
            ThingModelMessage message = new ThingModelMessage();
            BeanUtils.populate((Object)message, (Map)result);
            return message;
        }
        catch (Throwable e) {
            log.error("invoke decode script error", e);
            return null;
        }
    }

    @Override
    public TransparentMsg encode(ThingService<?> service) {
        try {
            ScriptObjectMirror result = (ScriptObjectMirror)this.engine.invokeMethod(this.scriptObj, "encode", new Object[]{service});
            Map map = (Map)JsonUtil.toObject((ScriptObjectMirror)result);
            TransparentMsg message = new TransparentMsg();
            BeanUtils.populate((Object)message, (Map)map);
            message.setProductKey(this.model.getProductKey());
            message.setModel(this.model.getModel());
            message.setDeviceName(service.getDeviceName());
            return message;
        }
        catch (Throwable e) {
            log.error("invoke encode script error", e);
            return null;
        }
    }

    public ProductModel getModel() {
        return this.model;
    }

    public NashornScriptEngine getEngine() {
        return this.engine;
    }

    public Object getScriptObj() {
        return this.scriptObj;
    }

    @Override
    public void setModel(ProductModel model) {
        this.model = model;
    }

    public void setScriptObj(Object scriptObj) {
        this.scriptObj = scriptObj;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsScripter)) {
            return false;
        }
        JsScripter other = (JsScripter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProductModel this$model = this.getModel();
        ProductModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        NashornScriptEngine this$engine = this.getEngine();
        NashornScriptEngine other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        Object this$scriptObj = this.getScriptObj();
        Object other$scriptObj = other.getScriptObj();
        return !(this$scriptObj == null ? other$scriptObj != null : !this$scriptObj.equals(other$scriptObj));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsScripter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProductModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        NashornScriptEngine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        Object $scriptObj = this.getScriptObj();
        result = result * 59 + ($scriptObj == null ? 43 : $scriptObj.hashCode());
        return result;
    }

    public String toString() {
        return "JsScripter(model=" + this.getModel() + ", engine=" + this.getEngine() + ", scriptObj=" + this.getScriptObj() + ")";
    }
}

