/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645;

import cc.iotkit.common.utils.JsonUtil;
import cc.iotkit.comp.DLT645.DLT645Config;
import cc.iotkit.comp.DLT645.analysis.DLT645Analysis;
import cc.iotkit.comp.DLT645.analysis.DLT645Data;
import cc.iotkit.comp.DLT645.analysis.DLT645FunCode;
import cc.iotkit.comp.DLT645.analysis.DLT645V1997Data;
import cc.iotkit.comp.DLT645.analysis.DLT645v1997CsvLoader;
import cc.iotkit.comp.DLT645.utils.ByteUtils;
import cc.iotkit.comp.DLT645.utils.ContainerUtils;
import cc.iotkit.comp.IMessageHandler;
import cc.iotkit.comp.model.ReceiveResult;
import cc.iotkit.converter.DeviceMessage;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLT645Verticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(DLT645Verticle.class);
    private IMessageHandler executor;
    private final DLT645Config config;
    private Map<String, NetSocket> clientMap = new ConcurrentHashMap<String, NetSocket>();
    private NetServer netServer;
    private List<DLT645Data> entityList;
    private Map<String, DLT645Data> dinMap;

    public DLT645Verticle(DLT645Config config) {
        this.config = config;
    }

    public void setExecutor(IMessageHandler executor) {
        this.executor = executor;
    }

    @Override
    public void start() {
        NetServerOptions options = new NetServerOptions().setPort(this.config.getPort());
        this.netServer = this.vertx.createNetServer(options);
        this.netServer.connectHandler(socket -> {
            log.info("TCP client connect address:{}", (Object)socket.remoteAddress());
            AtomicReference clientKey = new AtomicReference();
            HashMap dataMap = new HashMap();
            long timeoutId = this.vertx.setTimer(10000L, id -> socket.close());
            socket.handler(data -> {
                String hexStr = ByteUtils.byteArrayToHexString(data.getBytes(), false);
                log.info("Received message:{}", (Object)hexStr);
                if (hexStr.startsWith("67")) {
                    String funCode = hexStr.substring(2, 6);
                    log.info("\u6536\u5230\u81ea\u5b9a\u4e49\u6d88\u606f\uff0c\u884c\u4e3a\u7801\u4e3a\uff1a" + funCode + "\uff0c\u6570\u636e\u4e3a\uff1a" + hexStr);
                    if ("7267".equals(funCode)) {
                        String mac = hexStr.substring(6, 18);
                        dataMap.put("mac", mac);
                        this.executor.onReceive(dataMap, "register", "", r -> {
                            if (r != null) {
                                clientKey.set(this.getClientKey((ReceiveResult)r));
                                if (!this.clientMap.containsKey(clientKey.get())) {
                                    this.clientMap.put((String)clientKey.get(), (NetSocket)socket);
                                }
                                this.vertx.cancelTimer(timeoutId);
                                this.executor.onReceive(dataMap, "online", "");
                                socket.write(hexStr + "00");
                                return;
                            }
                            socket.write(hexStr + "99");
                        });
                    } else if ("6862".equals(funCode)) {
                        socket.write(hexStr + "00");
                        return;
                    }
                } else {
                    Map<String, Object> result = DLT645Analysis.unPackCmd2Map(ByteUtils.hexStringToByteArray(hexStr));
                    Object func = result.get("FUN");
                    DLT645FunCode funCode = DLT645FunCode.decodeEntity((Byte)func);
                    if (funCode.isError()) {
                        log.error("message erroe:{}", (Object)hexStr);
                        return;
                    }
                    byte[] adrrTmp = (byte[])result.get("ADR");
                    byte[] addr = new byte[6];
                    ByteUtils.byteInvertedOrder(adrrTmp, addr);
                    byte[] dat = (byte[])result.get("DAT");
                    DLT645V1997Data dataEntity = new DLT645V1997Data();
                    dataEntity.decodeValue(dat, this.dinMap);
                    HashMap<String, Object> unPack = new HashMap<String, Object>();
                    unPack.put("deviceAddress", ByteUtils.byteArrayToHexString(addr, false));
                    unPack.put("funCode", funCode.getCode());
                    unPack.put("identify", dataEntity.getKey());
                    unPack.put("data", dataEntity.getValue() + dataEntity.getUnit());
                    this.executor.onReceive(new HashMap(), "dlt", JsonUtil.toJsonString(unPack));
                }
            });
            socket.closeHandler(res -> {
                log.warn("TCP connection closed!");
                if (this.clientMap.containsKey(clientKey.get())) {
                    this.executor.onReceive(dataMap, "offline", "");
                    this.clientMap.remove(clientKey.get());
                }
            });
            socket.exceptionHandler(res -> {
                log.warn("TCP connection exception!");
                if (this.clientMap.containsKey(clientKey)) {
                    this.executor.onReceive(dataMap, "offline", "");
                    this.clientMap.remove(clientKey.get());
                }
            });
        });
        this.netServer.listen(res -> {
            if (res.succeeded()) {
                log.info("TCP server start success!");
                DLT645v1997CsvLoader template = new DLT645v1997CsvLoader();
                this.entityList = template.loadCsvFile();
                this.dinMap = ContainerUtils.buildMapByKey(this.entityList, DLT645V1997Data::getKey);
            } else {
                log.error("TCP server start fail: " + res.cause());
            }
        });
    }

    @Override
    public void stop() {
        for (String clientKey : this.clientMap.keySet()) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("mac", clientKey.split("_")[1]);
            this.executor.onReceive(dataMap, "offline", "");
        }
        if (this.entityList.size() > 0) {
            this.entityList.clear();
        }
        if (!this.dinMap.isEmpty()) {
            this.dinMap.clear();
        }
        this.clientMap.clear();
        this.netServer.close(voidAsyncResult -> log.info("close tcp server..."));
    }

    private String getClientKey(ReceiveResult result) {
        return this.getClientKey(result.getProductKey(), result.getDeviceName());
    }

    private String getClientKey(String productKey, String deviceName) {
        return String.format("%s_%s", productKey, deviceName);
    }

    public DeviceMessage sendMsg(DeviceMessage msg) {
        NetSocket client = this.clientMap.get(this.getClientKey(msg.getProductKey(), msg.getDeviceName()));
        log.info("send msg payload:{}", (Object)msg.getContent().toString());
        Future<Void> result = client.write(msg.getContent().toString());
        result.onFailure(e -> log.error("DLT645 server send msg failed", e));
        return msg;
    }
}

