/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core;

import com.ctg.ag.sdk.core.BaseApiClient;
import com.ctg.ag.sdk.core.constant.Scheme;
import com.ctg.ag.sdk.core.model.BuilderParams;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class BaseApiClientBuilder<Subclass extends BaseApiClientBuilder<?, ?>, TypeToBuild extends BaseApiClient> {
    private Random random = new Random();
    private BuilderParams params = new BuilderParams();

    public BaseApiClientBuilder<Subclass, TypeToBuild> appKey(String appKey) {
        this.params.setAppKey(appKey);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> appSecret(String appSecret) {
        this.params.setAppSecret(appSecret);
        return this;
    }

    @Deprecated
    public BaseApiClientBuilder<Subclass, TypeToBuild> maxIdleConnections(int maxIdleConnections) {
        this.params.setMaxIdleConnections(maxIdleConnections);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> maxIdleTimeMills(long maxIdleTimeMillis) {
        this.params.setMaxIdleTimeMillis(maxIdleTimeMillis);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> keepAliveDurationMillis(long keepAliveDurationMillis) {
        this.params.setKeepAliveDurationMillis(keepAliveDurationMillis);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> connectionTimeoutMillis(long connectionTimeoutMillis) {
        this.params.setConnectionTimeoutMillis(connectionTimeoutMillis);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> readTimeoutMillis(long readTimeoutMillis) {
        this.params.setReadTimeoutMillis(readTimeoutMillis);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> writeTimeoutMillis(long writeTimeoutMillis) {
        this.params.setWriteTimeoutMillis(writeTimeoutMillis);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> executorService(ExecutorService executorService) {
        this.params.setExecutorService(executorService);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.params.setSslSocketFactory(sslSocketFactory);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> maxRequests(int maxRequests) {
        this.params.setMaxRequests(maxRequests);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> maxRequestsPerHost(int maxRequestsPerHost) {
        this.params.setMaxRequestsPerHost(maxRequestsPerHost);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> idleCallback(Runnable idleCallback) {
        this.params.setIdleCallback(idleCallback);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> x509TrustManager(X509TrustManager x509TrustManager) {
        return this.x509TrustManagers(new X509TrustManager[]{x509TrustManager});
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> x509TrustManagers(X509TrustManager[] x509TrustManagers) {
        this.params.setX509TrustManagers(x509TrustManagers);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> keyManagers(KeyManager[] keyManagers) {
        this.params.setKeyManagers(keyManagers);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> secureRandom(SecureRandom secureRandom) {
        this.params.setSecureRandom(secureRandom);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.params.setHostnameVerifier(hostnameVerifier);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> setExtParams(String key, Object value) {
        this.params.setExtParam(key, value);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> scheme(Scheme scheme) {
        this.params.setScheme(scheme);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> sandbox(boolean sandbox) {
        this.params.setSandbox(sandbox);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> host(String host) {
        this.params.setHost(host);
        return this;
    }

    public BaseApiClientBuilder<Subclass, TypeToBuild> server(String server) {
        this.params.setServer(server);
        return this;
    }

    public final TypeToBuild build() {
        if (this.params.getScheme() == null) {
            this.params.setScheme(Scheme.HTTP);
        }
        if (this.params.getHost() == null) {
            boolean ssl;
            boolean sandbox = this.params.isSandbox();
            boolean bl = ssl = this.params.getScheme() == Scheme.HTTPS;
            if (!sandbox && !ssl) {
                this.params.setHost(this.httpHost());
            } else if (sandbox && ssl) {
                this.params.setHost(this.sandboxSslHost());
            } else if (!sandbox && ssl) {
                this.params.setHost(this.sslHost());
            } else if (sandbox && !ssl) {
                this.params.setHost(this.sandboxHttpHost());
            }
        }
        if (this.params.getServer() == null) {
            boolean ssl;
            boolean bl = ssl = this.params.getScheme() == Scheme.HTTPS;
            if (ssl) {
                this.params.setServer(this.serverSslHost());
            } else {
                this.params.setServer(this.serverHost());
            }
        } else {
            this.params.setHost(this.params.getHost().replace(this.serverHost(), this.params.getServer()));
        }
        TypeToBuild apiClient = this.build(this.params);
        return apiClient;
    }

    protected TypeToBuild build(BuilderParams params) {
        return (TypeToBuild)new BaseApiClient(params){};
    }

    protected String serverHost() {
        throw new UnsupportedOperationException();
    }

    protected String serverSslHost() {
        throw new UnsupportedOperationException();
    }

    protected String httpHost() {
        throw new UnsupportedOperationException();
    }

    protected String sslHost() {
        throw new UnsupportedOperationException();
    }

    protected String sandboxHttpHost() {
        throw new UnsupportedOperationException();
    }

    protected String sandboxSslHost() {
        throw new UnsupportedOperationException();
    }

    protected String nextHost(String[] hosts) {
        if (hosts.length == 0) {
            throw new UnsupportedOperationException("No available host");
        }
        return hosts[this.random.nextInt(hosts.length)];
    }
}

