/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core.model;

import com.ctg.ag.sdk.core.constant.Method;
import com.ctg.ag.sdk.core.constant.ParamPosition;
import com.ctg.ag.sdk.core.exception.SdkClientException;
import com.ctg.ag.sdk.core.http.RequestFormat;
import com.ctg.ag.sdk.core.model.BaseApiResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public abstract class BaseApiRequest
implements Cloneable {
    private RequestFormat method;
    private String scheme;
    private String host;
    private String path;
    private Map<String, String> globalParam = new HashMap<String, String>();
    private Map<String, List<String>> param;
    private byte[] body;
    private Map<String, Meta> meta;

    @Deprecated
    public BaseApiRequest(Method method, String version, Meta ... meta) {
        this.method = RequestFormat.type(method.getName(), ContentType.parse((String)method.getRequestContentType()), "utf-8");
        this.globalParam.put("version", version);
        this.param = new LinkedHashMap<String, List<String>>();
        this.meta = new LinkedHashMap<String, Meta>();
        for (Meta m : meta) {
            this.meta.put(m.getName(), m);
        }
    }

    public BaseApiRequest(RequestFormat method, String version, Meta ... meta) {
        this.method = method;
        this.globalParam.put("version", version);
        this.param = new LinkedHashMap<String, List<String>>();
        this.meta = new LinkedHashMap<String, Meta>();
        for (Meta m : meta) {
            this.meta.put(m.getName(), m);
        }
    }

    public abstract BaseApiResponse newResponse();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getParams(String name) {
        Meta m = this.meta.get(name);
        if (m == null) {
            throw new SdkClientException(String.format("Param %s not available", name));
        }
        List<String> ls = this.param.get(name);
        if (ls == null) {
            Map<String, List<String>> map = this.param;
            synchronized (map) {
                ls = this.param.get(name);
                if (ls == null) {
                    ls = new ArrayList<String>();
                    this.param.put(name, ls);
                }
            }
        }
        return ls;
    }

    public String getParam(String name) {
        List<String> ls = this.getParams(name);
        return ls.isEmpty() ? null : ls.iterator().next();
    }

    public List<String> addParams(String name, Iterable<?> values) {
        List<String> ls = this.getParams(name);
        if (values != null) {
            for (Object o : values) {
                this.addParam(name, o);
            }
        }
        return ls;
    }

    public List<String> addParam(String name, Object value) {
        List<String> ls = this.getParams(name);
        String s = null;
        if (value instanceof String) {
            s = (String)value;
        } else if (value != null) {
            s = value.toString();
        }
        ls.add(s);
        return ls;
    }

    public String setParam(String name, Object value) {
        List<String> ls = this.getParams(name);
        ls.clear();
        String s = null;
        if (value instanceof String) {
            s = (String)value;
        } else if (value != null) {
            s = value.toString();
        }
        ls.add(s);
        return s;
    }

    public Map<String, List<String>> getParam(ParamPosition ... position) {
        if (position.length == 0) {
            return this.param;
        }
        HashSet<ParamPosition> pos = new HashSet<ParamPosition>(Arrays.asList(position));
        LinkedHashMap<String, List<String>> res = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : this.param.entrySet()) {
            Meta m = this.meta.get(e.getKey());
            if (m == null || !pos.contains((Object)m.getPosition())) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    public RequestFormat getMethod() {
        return this.method;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, Meta> getMeta() {
        return this.meta;
    }

    public Map<String, String> getGlobalParam() {
        return this.globalParam;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setMethod(RequestFormat method) {
        this.method = method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String getSession() {
        return this.globalParam.get("session");
    }

    public void setSession(String session) {
        this.globalParam.put("session", session);
    }

    public String toString() {
        return "BaseApiRequest: method=" + this.method + " , scheme=" + this.scheme + " , host=" + this.host + " , path='" + this.path + '\'' + " , globalParam=" + this.globalParam + ", meta=" + this.meta;
    }

    public static class Meta {
        private String name;
        private ParamPosition position;

        public Meta(String name, ParamPosition position) {
            this.name = name;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public ParamPosition getPosition() {
            return this.position;
        }

        public String toString() {
            return "Meta: name=" + this.name + " , position=" + (Object)((Object)this.position);
        }
    }
}

