/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class AddressHelper {
    private AddressHelper() {
    }

    public static String defaultAddress() {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (nets.hasMoreElements()) {
            NetworkInterface netinf = nets.nextElement();
            Enumeration<InetAddress> addresses = netinf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isAnyLocalAddress() || address.isMulticastAddress() || address instanceof Inet6Address) continue;
                return address.getHostAddress();
            }
        }
        return null;
    }
}

