/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Promise;

public class SslHandshakeCompletionHandler
extends ChannelInboundHandlerAdapter {
    static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf((String)"sniServerName");
    private final Promise<Void> promise;

    public SslHandshakeCompletionHandler(Promise<Void> promise) {
        this.promise = promise;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof SniCompletionEvent) {
            SniCompletionEvent completion = (SniCompletionEvent)evt;
            Attribute val = ctx.channel().attr(SERVER_NAME_ATTR);
            val.set((Object)completion.hostname());
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
            if (completion.isSuccess()) {
                ctx.pipeline().remove((ChannelHandler)this);
                this.promise.setSuccess(null);
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }
}

