/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.biz;

import cc.iotkit.common.utils.JsonUtil;
import cc.iotkit.comp.CompConfig;
import cc.iotkit.comp.IComponent;
import cc.iotkit.comp.biz.HttpConfig;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBizComponent
implements IComponent {
    private static final Logger log = LoggerFactory.getLogger(HttpBizComponent.class);
    private final Vertx vertx = Vertx.vertx();
    private final NashornScriptEngine engine = (NashornScriptEngine)new ScriptEngineManager().getEngineByName("nashorn");
    private Object scriptObj;
    private CompConfig config;
    private HttpConfig httpConfig;
    private String script;
    private HttpServer backendServer;
    private String id;

    public void create(CompConfig config) {
        this.id = UUID.randomUUID().toString();
        this.httpConfig = (HttpConfig)JsonUtil.parse((String)config.getOther(), HttpConfig.class);
        try {
            this.scriptObj = this.engine.eval(String.format("new (function () {\n%s})()", this.script));
        }
        catch (ScriptException e) {
            log.error("init script error", (Throwable)e);
        }
    }

    public void start() {
        this.backendServer = this.vertx.createHttpServer();
        Router backendRouter = Router.router(this.vertx);
        backendRouter.route().handler(BodyHandler.create()).handler(rc -> {
            block9: {
                try {
                    Map<String, Object> httpHeader = HttpBizComponent.getData(rc.request().headers());
                    log.info("request header:{}", (Object)JsonUtil.toJsonString(httpHeader));
                    Map<String, List<Object>> httpParams = HttpBizComponent.getListData(rc.request().params());
                    log.info("request params:{}", (Object)JsonUtil.toJsonString(httpParams));
                    HttpServerRequest httpRequest = rc.request();
                    String contentType = httpRequest.headers().get("Content-Type");
                    JsonObject responseHeader = new JsonObject();
                    if ("application/json".equals(contentType)) {
                        String bodyStr = rc.getBody().toString();
                        Map body = (Map)JsonUtil.parse((String)bodyStr, Map.class);
                        log.info("request body:{}", (Object)bodyStr);
                        String response = "unknown error";
                        String name = "onReceive";
                        if (((ScriptObjectMirror)this.scriptObj).get((Object)name) != null) {
                            try {
                                Object result = this.engine.invokeMethod(this.scriptObj, name, new Object[]{httpRequest.method().name(), httpRequest.path(), httpHeader, httpParams, body});
                                Object resultObj = JsonUtil.toObject((ScriptObjectMirror)((ScriptObjectMirror)result));
                                if (resultObj instanceof Map) {
                                    JsonObject data = JsonObject.mapFrom(resultObj);
                                    responseHeader = data.getJsonObject("header");
                                    response = data.getString("content");
                                    response = response == null ? "" : response;
                                }
                            }
                            catch (Throwable e) {
                                log.error("invokeMethod onReceive error", e);
                                response = e.getMessage();
                            }
                        } else {
                            log.error("required [onReceive] method");
                        }
                        HttpServerResponse httpServerResponse = rc.response();
                        responseHeader.getMap().forEach((key, value) -> {
                            key = key.replaceAll("([A-Z])", "-$1").toLowerCase();
                            httpServerResponse.putHeader((String)key, value.toString());
                        });
                        log.info("response,header:{},content:{}", (Object)responseHeader, (Object)response);
                        httpServerResponse.end(response);
                        break block9;
                    }
                    rc.response().end("");
                }
                catch (Throwable e) {
                    log.error("handle request error", e);
                    rc.response().end("server error:" + e.getMessage());
                }
            }
        });
        this.backendServer.requestHandler(backendRouter).listen(this.httpConfig.getPort(), http -> {
            if (http.succeeded()) {
                log.info("http server create succeed,port:{}", (Object)this.httpConfig.getPort());
            } else {
                log.error("http server create failed", http.cause());
            }
        });
    }

    public void putScriptEnv(String key, Object value) {
        this.engine.put(key, value);
    }

    public void stop() {
        this.backendServer.close();
    }

    public void destroy() {
    }

    private static Map<String, List<Object>> getListData(MultiMap multiMap) {
        HashMap<String, List<Object>> listData = new HashMap<String, List<Object>>();
        for (Map.Entry<String, String> entry : multiMap.entries()) {
            String key = entry.getKey();
            String value = entry.getValue();
            listData.putIfAbsent(key, new ArrayList());
            ((List)listData.get(key)).add(value);
        }
        return listData;
    }

    private static Map<String, Object> getData(MultiMap multiMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : multiMap.entries()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return data;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public NashornScriptEngine getEngine() {
        return this.engine;
    }

    public Object getScriptObj() {
        return this.scriptObj;
    }

    public CompConfig getConfig() {
        return this.config;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public String getScript() {
        return this.script;
    }

    public HttpServer getBackendServer() {
        return this.backendServer;
    }

    public String getId() {
        return this.id;
    }

    public void setScriptObj(Object scriptObj) {
        this.scriptObj = scriptObj;
    }

    public void setConfig(CompConfig config) {
        this.config = config;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setBackendServer(HttpServer backendServer) {
        this.backendServer = backendServer;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpBizComponent)) {
            return false;
        }
        HttpBizComponent other = (HttpBizComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vertx this$vertx = this.getVertx();
        Vertx other$vertx = other.getVertx();
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        NashornScriptEngine this$engine = this.getEngine();
        NashornScriptEngine other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        Object this$scriptObj = this.getScriptObj();
        Object other$scriptObj = other.getScriptObj();
        if (this$scriptObj == null ? other$scriptObj != null : !this$scriptObj.equals(other$scriptObj)) {
            return false;
        }
        CompConfig this$config = this.getConfig();
        CompConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        HttpConfig this$httpConfig = this.getHttpConfig();
        HttpConfig other$httpConfig = other.getHttpConfig();
        if (this$httpConfig == null ? other$httpConfig != null : !((Object)this$httpConfig).equals(other$httpConfig)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        HttpServer this$backendServer = this.getBackendServer();
        HttpServer other$backendServer = other.getBackendServer();
        if (this$backendServer == null ? other$backendServer != null : !this$backendServer.equals(other$backendServer)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpBizComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertx $vertx = this.getVertx();
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        NashornScriptEngine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        Object $scriptObj = this.getScriptObj();
        result = result * 59 + ($scriptObj == null ? 43 : $scriptObj.hashCode());
        CompConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        HttpConfig $httpConfig = this.getHttpConfig();
        result = result * 59 + ($httpConfig == null ? 43 : ((Object)$httpConfig).hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        HttpServer $backendServer = this.getBackendServer();
        result = result * 59 + ($backendServer == null ? 43 : $backendServer.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "HttpBizComponent(vertx=" + this.getVertx() + ", engine=" + this.getEngine() + ", scriptObj=" + this.getScriptObj() + ", config=" + this.getConfig() + ", httpConfig=" + this.getHttpConfig() + ", script=" + this.getScript() + ", backendServer=" + this.getBackendServer() + ", id=" + this.getId() + ")";
    }
}

