/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.JavaArray;
import org.luaj.vm2.lib.jse.JavaClass;
import org.luaj.vm2.lib.jse.JavaInstance;

public class CoerceJavaToLua {
    static final Map COERCIONS = new HashMap();
    static final Coercion instanceCoercion;
    static final Coercion arrayCoercion;
    static final Coercion luaCoercion;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Class;

    public static LuaValue coerce(Object object) {
        if (object == null) {
            return LuaValue.NIL;
        }
        Class<?> clazz = object.getClass();
        Coercion coercion = (Coercion)COERCIONS.get(clazz);
        if (coercion == null) {
            coercion = clazz.isArray() ? arrayCoercion : (object instanceof LuaValue ? luaCoercion : instanceCoercion);
            COERCIONS.put(clazz, coercion);
        }
        return coercion.coerce(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BoolCoercion boolCoercion = new BoolCoercion();
        IntCoercion intCoercion = new IntCoercion();
        CharCoercion charCoercion = new CharCoercion();
        DoubleCoercion doubleCoercion = new DoubleCoercion();
        StringCoercion stringCoercion = new StringCoercion();
        BytesCoercion bytesCoercion = new BytesCoercion();
        ClassCoercion classCoercion = new ClassCoercion();
        COERCIONS.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = CoerceJavaToLua.class$("java.lang.Boolean")) : class$java$lang$Boolean, boolCoercion);
        COERCIONS.put(class$java$lang$Byte == null ? (class$java$lang$Byte = CoerceJavaToLua.class$("java.lang.Byte")) : class$java$lang$Byte, intCoercion);
        COERCIONS.put(class$java$lang$Character == null ? (class$java$lang$Character = CoerceJavaToLua.class$("java.lang.Character")) : class$java$lang$Character, charCoercion);
        COERCIONS.put(class$java$lang$Short == null ? (class$java$lang$Short = CoerceJavaToLua.class$("java.lang.Short")) : class$java$lang$Short, intCoercion);
        COERCIONS.put(class$java$lang$Integer == null ? (class$java$lang$Integer = CoerceJavaToLua.class$("java.lang.Integer")) : class$java$lang$Integer, intCoercion);
        COERCIONS.put(class$java$lang$Long == null ? (class$java$lang$Long = CoerceJavaToLua.class$("java.lang.Long")) : class$java$lang$Long, doubleCoercion);
        COERCIONS.put(class$java$lang$Float == null ? (class$java$lang$Float = CoerceJavaToLua.class$("java.lang.Float")) : class$java$lang$Float, doubleCoercion);
        COERCIONS.put(class$java$lang$Double == null ? (class$java$lang$Double = CoerceJavaToLua.class$("java.lang.Double")) : class$java$lang$Double, doubleCoercion);
        COERCIONS.put(class$java$lang$String == null ? (class$java$lang$String = CoerceJavaToLua.class$("java.lang.String")) : class$java$lang$String, stringCoercion);
        COERCIONS.put(array$B == null ? (array$B = CoerceJavaToLua.class$("[B")) : array$B, bytesCoercion);
        COERCIONS.put(class$java$lang$Class == null ? (class$java$lang$Class = CoerceJavaToLua.class$("java.lang.Class")) : class$java$lang$Class, classCoercion);
        instanceCoercion = new InstanceCoercion();
        arrayCoercion = new ArrayCoercion();
        luaCoercion = new LuaCoercion();
    }

    private static final class LuaCoercion
    implements Coercion {
        private LuaCoercion() {
        }

        public LuaValue coerce(Object object) {
            return (LuaValue)object;
        }
    }

    private static final class ArrayCoercion
    implements Coercion {
        private ArrayCoercion() {
        }

        public LuaValue coerce(Object object) {
            return new JavaArray(object);
        }
    }

    private static final class InstanceCoercion
    implements Coercion {
        private InstanceCoercion() {
        }

        public LuaValue coerce(Object object) {
            return new JavaInstance(object);
        }
    }

    private static final class ClassCoercion
    implements Coercion {
        private ClassCoercion() {
        }

        public LuaValue coerce(Object object) {
            return JavaClass.forClass((Class)object);
        }
    }

    private static final class BytesCoercion
    implements Coercion {
        private BytesCoercion() {
        }

        public LuaValue coerce(Object object) {
            return LuaValue.valueOf((byte[])object);
        }
    }

    private static final class StringCoercion
    implements Coercion {
        private StringCoercion() {
        }

        public LuaValue coerce(Object object) {
            return LuaString.valueOf(object.toString());
        }
    }

    private static final class DoubleCoercion
    implements Coercion {
        private DoubleCoercion() {
        }

        public LuaValue coerce(Object object) {
            Number number = (Number)object;
            return LuaDouble.valueOf(number.doubleValue());
        }
    }

    private static final class CharCoercion
    implements Coercion {
        private CharCoercion() {
        }

        public LuaValue coerce(Object object) {
            Character c = (Character)object;
            return LuaInteger.valueOf(c.charValue());
        }
    }

    private static final class IntCoercion
    implements Coercion {
        private IntCoercion() {
        }

        public LuaValue coerce(Object object) {
            Number number = (Number)object;
            return LuaInteger.valueOf(number.intValue());
        }
    }

    private static final class BoolCoercion
    implements Coercion {
        private BoolCoercion() {
        }

        public LuaValue coerce(Object object) {
            Boolean bl = (Boolean)object;
            return bl != false ? LuaValue.TRUE : LuaValue.FALSE;
        }
    }

    static interface Coercion {
        public LuaValue coerce(Object var1);
    }
}

