/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.mqtt;

import cc.iotkit.common.thing.ThingService;
import cc.iotkit.comp.mqtt.IScripter;
import cc.iotkit.comp.mqtt.JsScripter;
import cc.iotkit.comp.mqtt.LuaScripter;
import cc.iotkit.comp.mqtt.TransparentMsg;
import cc.iotkit.comp.utils.SpringUtils;
import cc.iotkit.converter.Device;
import cc.iotkit.converter.DeviceMessage;
import cc.iotkit.data.IDeviceInfoData;
import cc.iotkit.data.IProductModelData;
import cc.iotkit.model.device.DeviceInfo;
import cc.iotkit.model.device.message.ThingModelMessage;
import cc.iotkit.model.product.ProductModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransparentConverter {
    private static final Logger log = LoggerFactory.getLogger(TransparentConverter.class);
    private final Map<String, IScripter> scripters = new HashMap<String, IScripter>();
    private final Map<String, String> scripts = new HashMap<String, String>();
    private IDeviceInfoData deviceInfoData;
    private IProductModelData productModelData;

    public ThingModelMessage decode(TransparentMsg msg) {
        String productKey = msg.getProductKey();
        productKey = this.checkScriptUpdate(productKey, msg.getModel());
        msg.setProductKey(productKey);
        ThingModelMessage decodeMsg = this.scripters.get(productKey).decode(msg);
        decodeMsg.setProductKey(msg.getProductKey());
        decodeMsg.setDeviceName(msg.getDeviceName());
        return decodeMsg;
    }

    public DeviceMessage encode(ThingService<?> service, Device device) {
        String productKey = service.getProductKey();
        this.checkScriptUpdate(productKey, device.getModel());
        TransparentMsg transparentMsg = this.scripters.get(productKey).encode(service);
        String deviceName = service.getDeviceName();
        DeviceInfo gateway = this.getGatewayInfo(productKey, deviceName);
        DeviceMessage message = new DeviceMessage();
        message.setProductKey(gateway.getProductKey());
        message.setDeviceName(gateway.getDeviceName());
        message.setMid(transparentMsg.getMid());
        message.setContent((Object)transparentMsg);
        return message;
    }

    private ProductModel getScript(String model) {
        if (this.productModelData == null) {
            this.productModelData = (IProductModelData)SpringUtils.getBean((String)"productModelDataCache");
        }
        return this.productModelData.findByModel(model);
    }

    private DeviceInfo getGatewayInfo(String subPk, String subDn) {
        if (this.deviceInfoData == null) {
            this.deviceInfoData = (IDeviceInfoData)SpringUtils.getBean((String)"deviceInfoDataCache");
        }
        String parentId = this.deviceInfoData.findByProductKeyAndDeviceName(subPk, subDn).getParentId();
        return this.deviceInfoData.findByDeviceId(parentId);
    }

    private String checkScriptUpdate(String pk, String model) {
        String oldScript;
        ProductModel productModel = null;
        if (StringUtils.isNotBlank((CharSequence)model)) {
            productModel = this.getScript(model);
        }
        if (productModel == null && StringUtils.isNotBlank((CharSequence)pk)) {
            productModel = this.getScript(ProductModel.getDefaultModel((String)pk));
        }
        if (productModel == null) {
            throw new RuntimeException("product model script does not exist");
        }
        String productKey = productModel.getProductKey();
        String script = productModel.getScript();
        if (script.equals(oldScript = this.scripts.get(productKey))) {
            return productKey;
        }
        String type2 = productModel.getType();
        if ("LuaScript".equals(type2)) {
            this.scripters.putIfAbsent(productKey, new LuaScripter(productModel));
        } else if ("JavaScript".equals(type2)) {
            this.scripters.putIfAbsent(productKey, new JsScripter(productModel));
        }
        IScripter scripter = this.scripters.get(productKey);
        scripter.setScript(script);
        this.scripts.put(productKey, script);
        return productKey;
    }
}

