/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.ParsedHeaderValues;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;

@VertxGen
public interface RoutingContext {
    @CacheReturn
    public HttpServerRequest request();

    @CacheReturn
    public HttpServerResponse response();

    public void next();

    public void fail(int var1);

    public void fail(Throwable var1);

    public void fail(int var1, Throwable var2);

    @Fluent
    public RoutingContext put(String var1, Object var2);

    public <T> @Nullable T get(String var1);

    public <T> T get(String var1, T var2);

    public <T> @Nullable T remove(String var1);

    @GenIgnore(value={"permitted-type"})
    public Map<String, Object> data();

    @CacheReturn
    public Vertx vertx();

    public @Nullable String mountPoint();

    public @Nullable Route currentRoute();

    @Deprecated
    default public String normalisedPath() {
        return this.normalizedPath();
    }

    public String normalizedPath();

    @Deprecated
    public @Nullable Cookie getCookie(String var1);

    @Deprecated
    @Fluent
    public RoutingContext addCookie(Cookie var1);

    @Deprecated
    default public @Nullable Cookie removeCookie(String name) {
        return this.removeCookie(name, true);
    }

    @Deprecated
    public @Nullable Cookie removeCookie(String var1, boolean var2);

    @Deprecated
    public int cookieCount();

    @Deprecated
    public Map<String, Cookie> cookieMap();

    public @Nullable String getBodyAsString();

    public @Nullable String getBodyAsString(String var1);

    public @Nullable JsonObject getBodyAsJson(int var1);

    public @Nullable JsonArray getBodyAsJsonArray(int var1);

    default public @Nullable JsonObject getBodyAsJson() {
        return this.getBodyAsJson(-1);
    }

    default public @Nullable JsonArray getBodyAsJsonArray() {
        return this.getBodyAsJsonArray(-1);
    }

    public @Nullable Buffer getBody();

    public Set<FileUpload> fileUploads();

    public @Nullable Session session();

    public boolean isSessionAccessed();

    public @Nullable User user();

    @CacheReturn
    public @Nullable Throwable failure();

    @CacheReturn
    public int statusCode();

    public @Nullable String getAcceptableContentType();

    @CacheReturn
    public ParsedHeaderValues parsedHeaders();

    public int addHeadersEndHandler(Handler<Void> var1);

    public boolean removeHeadersEndHandler(int var1);

    public int addBodyEndHandler(Handler<Void> var1);

    public boolean removeBodyEndHandler(int var1);

    public int addEndHandler(Handler<AsyncResult<Void>> var1);

    default public Future<Void> addEndHandler() {
        Promise<Void> promise = Promise.promise();
        this.addEndHandler(promise);
        return promise.future();
    }

    public boolean removeEndHandler(int var1);

    public boolean failed();

    public void setBody(Buffer var1);

    public void setSession(Session var1);

    public void setUser(User var1);

    public void clearUser();

    public void setAcceptableContentType(@Nullable String var1);

    default public void reroute(String path) {
        this.reroute(this.request().method(), path);
    }

    public void reroute(HttpMethod var1, String var2);

    @CacheReturn
    default public List<LanguageHeader> acceptableLanguages() {
        return this.parsedHeaders().acceptLanguage();
    }

    @CacheReturn
    default public LanguageHeader preferredLanguage() {
        List<LanguageHeader> acceptableLanguages = this.acceptableLanguages();
        return acceptableLanguages.size() > 0 ? acceptableLanguages.get(0) : null;
    }

    public Map<String, String> pathParams();

    public @Nullable String pathParam(String var1);

    public MultiMap queryParams();

    @GenIgnore(value={"permitted-type"})
    public MultiMap queryParams(Charset var1);

    public List<String> queryParam(String var1);

    @Fluent
    default public RoutingContext attachment(String filename) {
        String contentType;
        if (filename != null && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
            this.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        }
        this.response().putHeader(HttpHeaders.CONTENT_DISPOSITION, (CharSequence)("attachment; filename=" + filename));
        return this;
    }

    default public Future<Void> redirect(String url) {
        if ("back".equals(url) && (url = this.request().getHeader(HttpHeaders.REFERER)) == null) {
            url = "/";
        }
        this.response().putHeader(HttpHeaders.LOCATION, (CharSequence)url);
        int status2 = this.response().getStatusCode();
        if (status2 < 300 || status2 >= 400) {
            this.response().setStatusCode(302);
        }
        return this.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=utf-8").end("Redirecting to " + url + ".");
    }

    @Fluent
    default public RoutingContext redirect(String url, Handler<AsyncResult<Void>> handler) {
        this.redirect(url).onComplete(handler);
        return this;
    }

    default public Future<Void> json(Object json) {
        HttpServerResponse res = this.response();
        if (json == null) {
            res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            return res.end("null");
        }
        try {
            Buffer buffer = Json.encodeToBuffer(json);
            res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            return res.end(buffer);
        }
        catch (EncodeException | UnsupportedOperationException e) {
            this.fail(e);
            return Future.failedFuture(e);
        }
    }

    @Fluent
    default public RoutingContext json(Object json, Handler<AsyncResult<Void>> handler) {
        this.json(json).onComplete(handler);
        return this;
    }

    @CacheReturn
    default public boolean is(String type2) {
        MIMEHeader contentType = this.parsedHeaders().contentType();
        if (contentType == null) {
            return false;
        }
        ParsableMIMEValue value = type2.indexOf(47) == -1 ? new ParsableMIMEValue("*/" + type2).forceParse() : new ParsableMIMEValue(type2).forceParse();
        return contentType.isMatchedBy(value);
    }

    default public boolean isFresh() {
        HttpMethod method = this.request().method();
        if (method != HttpMethod.GET && method != HttpMethod.HEAD) {
            return false;
        }
        int s = this.response().getStatusCode();
        if (s >= 200 && s < 300 || 304 == s) {
            return Utils.fresh(this);
        }
        return false;
    }

    @Fluent
    default public RoutingContext etag(String etag) {
        boolean quoted;
        boolean bl = quoted = etag.length() > 2 && (etag.charAt(0) == '\"' || etag.startsWith("W/\"")) && etag.charAt(etag.length() - 1) == '\"';
        if (!quoted) {
            this.response().putHeader(HttpHeaders.ETAG, (CharSequence)("\"" + etag + "\""));
        } else {
            this.response().putHeader(HttpHeaders.ETAG, (CharSequence)etag);
        }
        return this;
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public RoutingContext lastModified(Instant instant) {
        this.response().putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)Utils.formatRFC1123DateTime(instant.toEpochMilli()));
        return this;
    }

    @Fluent
    default public RoutingContext lastModified(String instant) {
        this.response().putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)instant);
        return this;
    }

    default public Future<Void> end(String chunk) {
        return this.response().end(chunk);
    }

    @Fluent
    default public RoutingContext end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(chunk).onComplete(handler);
        return this;
    }

    default public Future<Void> end(Buffer buffer) {
        return this.response().end(buffer);
    }

    @Fluent
    default public RoutingContext end(Buffer buffer, Handler<AsyncResult<Void>> handler) {
        this.end(buffer).onComplete(handler);
        return this;
    }

    default public Future<Void> end() {
        return this.response().end();
    }

    @Fluent
    default public RoutingContext end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
        return this;
    }
}

