/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core;

import com.ctg.ag.sdk.core.HttpClient;
import com.ctg.ag.sdk.core.constant.ParamPosition;
import com.ctg.ag.sdk.core.exception.SdkClientException;
import com.ctg.ag.sdk.core.http.HttpClientFactory;
import com.ctg.ag.sdk.core.http.RequestFormat;
import com.ctg.ag.sdk.core.model.ApiCallBack;
import com.ctg.ag.sdk.core.model.BaseApiRequest;
import com.ctg.ag.sdk.core.model.BaseApiResponse;
import com.ctg.ag.sdk.core.model.BuilderParams;
import com.ctg.ag.sdk.core.util.Signature;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Future;

public abstract class BaseApiClient {
    protected final String appKey;
    protected final String appSecret;
    protected final HttpClient httpClient;
    protected static long offset;
    protected static long lastGetOffsetTime;
    protected final String host;
    protected final String scheme;
    protected final String server;

    public BaseApiClient(BuilderParams builderParams) {
        this.appKey = builderParams.getAppKey();
        this.appSecret = builderParams.getAppSecret();
        this.httpClient = HttpClientFactory.buildClient(builderParams);
        this.host = builderParams.getHost();
        this.scheme = builderParams.getScheme().getValue();
        this.server = builderParams.getServer();
        offset = this.getOffset();
    }

    private long getOffset() {
        long current = System.currentTimeMillis();
        if (current - lastGetOffsetTime > 600000L) {
            offset = this.timeSync(this.server);
            lastGetOffsetTime = current;
        }
        return offset;
    }

    private long timeSync(String server) {
        BaseApiRequest syncRequet = new BaseApiRequest(RequestFormat.GET(), null, new BaseApiRequest.Meta[0]){

            @Override
            public BaseApiResponse newResponse() {
                return new BaseApiResponse(){};
            }
        };
        syncRequet.setHost(server);
        syncRequet.setPath("/echo");
        try {
            long start = System.currentTimeMillis();
            BaseApiResponse response = this.httpClient.syncInvoke(syncRequet);
            long end = System.currentTimeMillis();
            Map<String, String> headers = response.getHeaders();
            long serviceTime = Double.valueOf(headers.get("x-ag-timestamp")).longValue();
            return serviceTime - (end + start) / 2L;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to synchronize time from server: " + syncRequet, e);
        }
    }

    private <REQ extends BaseApiRequest> REQ buildSDKRequest(REQ apiReq) throws Exception {
        String pathWithPathParameter = this.combinePathParam(apiReq.getPath(), apiReq.getParam(ParamPosition.PATH));
        apiReq.setPath(pathWithPathParameter);
        Date current = new Date(System.currentTimeMillis() + this.getOffset());
        apiReq.getGlobalParam().put("timestamp", String.valueOf(current.getTime()));
        apiReq.getGlobalParam().put("application", this.appKey);
        if (this.appSecret != null && !this.appSecret.isEmpty()) {
            TreeMap<String, List<String>> input = new TreeMap<String, List<String>>();
            for (String s : apiReq.getMeta().keySet()) {
                List<String> value = apiReq.getParams(s);
                input.put(s, value);
            }
            apiReq.getGlobalParam().put("signature", Signature.sign(this.appSecret, apiReq.getGlobalParam().get("application"), apiReq.getGlobalParam().get("timestamp"), input, apiReq.getBody()));
        }
        apiReq.getGlobalParam().put("Date", this.getHttpDateHeaderValue(current));
        apiReq.getGlobalParam().put("User-Agent", "Telecom API Gateway Java SDK");
        apiReq.getGlobalParam().put("version", apiReq.getGlobalParam().get("version"));
        apiReq.getGlobalParam().put("sdk", "GIT: a4fb7fca");
        apiReq.getGlobalParam().put("Content-Type", apiReq.getMethod().getContentType().toString());
        if (apiReq.getGlobalParam().get("version") == null || apiReq.getGlobalParam().get("version").trim().isEmpty()) {
            apiReq.getGlobalParam().remove("version");
        }
        return apiReq;
    }

    private String combinePathParam(String path, Map<String, List<String>> pathParams) {
        if (pathParams == null) {
            return path;
        }
        for (String key : pathParams.keySet()) {
            path = path.replace("[" + key + "]", pathParams.get(key).iterator().next());
        }
        return path;
    }

    private String getHttpDateHeaderValue(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public final <R extends BaseApiResponse> R syncInvoke(BaseApiRequest apiRequest) throws Exception {
        try {
            apiRequest = this.buildSDKRequest(apiRequest);
            return (R)this.httpClient.syncInvoke(apiRequest);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
    }

    public final <REQ extends BaseApiRequest, RESP extends BaseApiResponse> Future<RESP> asyncInvoke(REQ apiRequest, ApiCallBack<REQ, RESP> callback) {
        try {
            apiRequest = this.buildSDKRequest(apiRequest);
            return this.httpClient.asyncInvoke(apiRequest, callback);
        }
        catch (Exception e) {
            throw new SdkClientException(e);
        }
    }

    public void shutdown() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        lastGetOffsetTime = 0L;
    }
}

