/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645;

import cc.iotkit.common.enums.ErrCode;
import cc.iotkit.common.exception.BizException;
import cc.iotkit.comp.AbstractDeviceComponent;
import cc.iotkit.comp.CompConfig;
import cc.iotkit.comp.DLT645.DLT645Config;
import cc.iotkit.comp.DLT645.DLT645Verticle;
import cc.iotkit.comp.utils.JsonUtil;
import cc.iotkit.converter.DeviceMessage;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLT645Component
extends AbstractDeviceComponent {
    private static final Logger log = LoggerFactory.getLogger(DLT645Component.class);
    private Vertx vertx;
    private CountDownLatch countDownLatch;
    private DLT645Verticle DLT645Verticle;
    private String deployedId;
    private String id;

    public void create(CompConfig config) {
        super.create(config);
        this.vertx = Vertx.vertx();
        this.id = UUID.randomUUID().toString();
        DLT645Config DLT645Config2 = (DLT645Config)JsonUtil.parse((String)config.getOther(), DLT645Config.class);
        this.DLT645Verticle = new DLT645Verticle(DLT645Config2);
    }

    public void start() {
        try {
            this.DLT645Verticle.setExecutor(this.getHandler());
            this.countDownLatch = new CountDownLatch(1);
            Future<String> future = this.vertx.deployVerticle(this.DLT645Verticle);
            future.onSuccess(s -> {
                this.deployedId = s;
                this.countDownLatch.countDown();
            });
            future.onFailure(e -> {
                this.countDownLatch.countDown();
                log.error("start GLT645 component failed", e);
            });
            this.countDownLatch.await();
            future.succeeded();
        }
        catch (Throwable e2) {
            throw new BizException(ErrCode.COMPONENT_START_ERROR, e2);
        }
    }

    public void stop() {
        this.DLT645Verticle.stop();
        Future<Void> future = this.vertx.undeploy(this.deployedId);
        future.onSuccess(unused -> log.info("stop GLT645 component success"));
    }

    public void destroy() {
    }

    public DeviceMessage send(DeviceMessage message) {
        this.DLT645Verticle.sendMsg(message);
        return message;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public DLT645Verticle getDLT645Verticle() {
        return this.DLT645Verticle;
    }

    public String getDeployedId() {
        return this.deployedId;
    }

    public String getId() {
        return this.id;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void setDLT645Verticle(DLT645Verticle DLT645Verticle2) {
        this.DLT645Verticle = DLT645Verticle2;
    }

    public void setDeployedId(String deployedId) {
        this.deployedId = deployedId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DLT645Component)) {
            return false;
        }
        DLT645Component other = (DLT645Component)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Vertx this$vertx = this.getVertx();
        Vertx other$vertx = other.getVertx();
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        CountDownLatch this$countDownLatch = this.getCountDownLatch();
        CountDownLatch other$countDownLatch = other.getCountDownLatch();
        if (this$countDownLatch == null ? other$countDownLatch != null : !this$countDownLatch.equals(other$countDownLatch)) {
            return false;
        }
        DLT645Verticle this$DLT645Verticle = this.getDLT645Verticle();
        DLT645Verticle other$DLT645Verticle = other.getDLT645Verticle();
        if (this$DLT645Verticle == null ? other$DLT645Verticle != null : !this$DLT645Verticle.equals(other$DLT645Verticle)) {
            return false;
        }
        String this$deployedId = this.getDeployedId();
        String other$deployedId = other.getDeployedId();
        if (this$deployedId == null ? other$deployedId != null : !this$deployedId.equals(other$deployedId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DLT645Component;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertx $vertx = this.getVertx();
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        CountDownLatch $countDownLatch = this.getCountDownLatch();
        result = result * 59 + ($countDownLatch == null ? 43 : $countDownLatch.hashCode());
        DLT645Verticle $DLT645Verticle = this.getDLT645Verticle();
        result = result * 59 + ($DLT645Verticle == null ? 43 : $DLT645Verticle.hashCode());
        String $deployedId = this.getDeployedId();
        result = result * 59 + ($deployedId == null ? 43 : $deployedId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "DLT645Component(vertx=" + this.getVertx() + ", countDownLatch=" + this.getCountDownLatch() + ", DLT645Verticle=" + this.getDLT645Verticle() + ", deployedId=" + this.getDeployedId() + ", id=" + this.getId() + ")";
    }
}

