/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.function.Supplier;

public class Http1xServerConnection
extends Http1xConnectionBase<ServerWebSocketImpl>
implements HttpServerConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private final String serverOrigin;
    private final Supplier<ContextInternal> streamContextSupplier;
    private final SSLHelper sslHelper;
    private final TracingPolicy tracingPolicy;
    private boolean requestFailed;
    private Http1xServerRequest requestInProgress;
    private Http1xServerRequest responseInProgress;
    private boolean channelPaused;
    private boolean writable;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<HttpServerRequest> invalidRequestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;

    public Http1xServerConnection(Supplier<ContextInternal> streamContextSupplier, SSLHelper sslHelper, HttpServerOptions options, ChannelHandlerContext chctx, ContextInternal context, String serverOrigin, HttpServerMetrics metrics) {
        super(context, chctx);
        this.serverOrigin = serverOrigin;
        this.streamContextSupplier = streamContextSupplier;
        this.options = options;
        this.sslHelper = sslHelper;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
        this.tracingPolicy = options.getTracingPolicy();
        this.writable = true;
    }

    TracingPolicy tracingPolicy() {
        return this.tracingPolicy;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        this.invalidRequestHandler = handler;
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void handleMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            Http1xServerRequest req;
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            ContextInternal requestCtx = this.streamContextSupplier.get();
            this.requestInProgress = req = new Http1xServerRequest(this, (HttpRequest)request, requestCtx);
            if (this.responseInProgress != null) {
                this.enqueueRequest(req);
                return;
            }
            this.responseInProgress = this.requestInProgress;
            req.handleBegin(this.writable);
            Handler<HttpServerRequest> handler = request.decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            req.context.emit(req, handler);
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.onEnd();
        } else {
            this.handleOther(msg);
        }
    }

    private void enqueueRequest(Http1xServerRequest req) {
        this.responseInProgress.enqueue(req);
        req.pause();
    }

    private void handleOther(Object msg) {
        if (msg instanceof HttpContent) {
            this.onContent(msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContent(Object msg) {
        Http1xServerRequest request;
        HttpContent content = (HttpContent)msg;
        if (!content.decoderResult().isSuccess()) {
            this.handleError((HttpObject)content);
            return;
        }
        Buffer buffer = Buffer.buffer(VertxHandler.safeBuffer(content.content()));
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            request = this.requestInProgress;
        }
        request.context.execute(buffer, request::handleContent);
        if (content instanceof LastHttpContent) {
            this.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        Http1xServerRequest request;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            request = this.requestInProgress;
            this.requestInProgress = null;
        }
        request.context.execute(request, Http1xServerRequest::handleEnd);
    }

    void responseComplete() {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            if (Metrics.METRICS_ENABLED) {
                this.reportResponseComplete();
            }
            Http1xServerRequest request = this.responseInProgress;
            this.responseInProgress = null;
            DecoderResult result = request.decoderResult();
            if (result.isSuccess()) {
                Http1xServerRequest next2 = request.next();
                if (next2 != null) {
                    this.handleNext(next2);
                }
            } else {
                ChannelPromise channelFuture = this.channelFuture();
                this.writeToChannel((Object)Unpooled.EMPTY_BUFFER, channelFuture);
                channelFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> this.fail(result.cause())));
            }
        } else {
            eventLoop.execute(this::responseComplete);
        }
    }

    private void handleNext(Http1xServerRequest next2) {
        this.responseInProgress = next2;
        next2.handleBegin(this.writable);
        this.context.emit(next2, next_ -> {
            next_.resume();
            Handler<HttpServerRequest> handler = next_.nettyRequest().decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            handler.handle((HttpServerRequest)next_);
        });
    }

    @Override
    public void doPause() {
        if (!this.channelPaused) {
            this.channelPaused = true;
            super.doPause();
        }
    }

    @Override
    public void doResume() {
        if (this.channelPaused) {
            this.channelPaused = false;
            super.doResume();
        }
    }

    private void reportResponseComplete() {
        Http1xServerRequest request = this.responseInProgress;
        if (this.metrics != null) {
            this.flushBytesWritten();
            if (this.requestFailed) {
                this.metrics.requestReset(request.metric());
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
            }
        }
        VertxTracer tracer = this.context.tracer();
        Object trace = request.trace();
        if (tracer != null && trace != null) {
            tracer.sendResponse(request.context, request.response(), trace, null, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    void createWebSocket(Http1xServerRequest request, PromiseInternal<ServerWebSocket> promise) {
        this.context.execute(() -> {
            if (request != this.responseInProgress) {
                promise.fail("Invalid request");
            } else if (this.webSocket != null) {
                promise.complete((ServerWebSocket)((Object)this.webSocket));
            } else if (!(request.nettyRequest() instanceof FullHttpRequest)) {
                promise.fail(new IllegalStateException());
            } else {
                WebSocketServerHandshaker handshaker;
                try {
                    handshaker = this.createHandshaker(request);
                }
                catch (WebSocketHandshakeException e) {
                    promise.fail(e);
                    return;
                }
                this.webSocket = new ServerWebSocketImpl(promise.context(), this, handshaker.version() != WebSocketVersion.V00, this.options.getWebSocketClosingTimeout(), request, handshaker, this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize());
                if (Metrics.METRICS_ENABLED && this.metrics != null) {
                    ((ServerWebSocketImpl)this.webSocket).setMetric(this.metrics.connected(this.metric(), request.metric(), (ServerWebSocket)((Object)this.webSocket)));
                }
                promise.complete((ServerWebSocket)((Object)this.webSocket));
            }
        });
    }

    private WebSocketServerHandshaker createHandshaker(Http1xServerRequest request) throws WebSocketHandshakeException {
        WebSocketDecoderConfig config;
        WebSocketServerHandshakerFactory factory;
        WebSocketServerHandshaker shake;
        String wsURL;
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            throw new WebSocketHandshakeException("Invalid connection header");
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            throw new WebSocketHandshakeException("Invalid HTTP method");
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            throw new WebSocketHandshakeException("Invalid WebSocket location", (Throwable)e);
        }
        String subProtocols = null;
        if (this.options.getWebSocketSubProtocols() != null) {
            subProtocols = String.join((CharSequence)",", this.options.getWebSocketSubProtocols());
        }
        if ((shake = (factory = new WebSocketServerHandshakerFactory(wsURL, subProtocols, config = WebSocketDecoderConfig.newBuilder().allowExtensions(this.options.getPerMessageWebSocketCompressionSupported() || this.options.getPerFrameWebSocketCompressionSupported()).maxFramePayloadLength(this.options.getMaxWebSocketFrameSize()).allowMaskMismatch(this.options.isAcceptUnmaskedFrames()).closeOnProtocolViolation(false).build())).newHandshaker(request.nettyRequest())) != null) {
            return shake;
        }
        request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        throw new WebSocketHandshakeException("Invalid WebSocket version");
    }

    public void netSocket(Handler<AsyncResult<NetSocket>> handler) {
        Future<NetSocket> fut = this.netSocket();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<NetSocket> netSocket() {
        PromiseInternal<NetSocket> promise = this.context.promise();
        this.netSocket((Promise<NetSocket>)promise);
        return promise.future();
    }

    void netSocket(Promise<NetSocket> promise) {
        this.context.execute(() -> {
            this.flush();
            ChannelPipeline pipeline = this.chctx.pipeline();
            HttpChunkContentCompressor compressor = pipeline.get(HttpChunkContentCompressor.class);
            if (compressor != null) {
                pipeline.remove((ChannelHandler)((Object)compressor));
            }
            pipeline.remove("httpDecoder");
            if (pipeline.get("chunkedWriter") != null) {
                pipeline.remove("chunkedWriter");
            }
            pipeline.replace("handler", "handler", VertxHandler.create(ctx -> {
                NetSocketImpl socket = new NetSocketImpl(this.context, (ChannelHandlerContext)ctx, this.sslHelper, this.metrics){

                    @Override
                    protected void handleClosed() {
                        if (Http1xServerConnection.this.metrics != null) {
                            Http1xServerRequest request = Http1xServerConnection.this.responseInProgress;
                            Http1xServerConnection.this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
                        }
                        super.handleClosed();
                    }

                    @Override
                    public synchronized void handleMessage(Object msg) {
                        if (msg instanceof HttpContent) {
                            ReferenceCountUtil.release(msg);
                            return;
                        }
                        super.handleMessage(msg);
                    }
                };
                socket.metric(this.metric());
                return socket;
            }));
            pipeline.remove("httpEncoder");
            VertxHandler handler = (VertxHandler)pipeline.get("handler");
            promise.complete((NetSocket)handler.getConnection());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        this.writable = !this.isNotWritable();
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (this.responseInProgress != null) {
                context = this.responseInProgress.context;
                handler = this.responseInProgress.response()::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((ServerWebSocketImpl)this.webSocket).context;
                handler = ((ServerWebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        context.execute(this.writable, handler);
    }

    void write100Continue() {
        this.chctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        Http1xServerRequest responseInProgress;
        Http1xServerRequest requestInProgress;
        ServerWebSocketImpl ws;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.webSocket;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
        }
        if (requestInProgress != null) {
            requestInProgress.context.execute(v -> requestInProgress.handleException(CLOSED_EXCEPTION));
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.context.execute(v -> responseInProgress.handleException(CLOSED_EXCEPTION));
        }
        if (ws != null) {
            ws.context.execute(v -> ws.handleConnectionClosed());
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable t) {
        Http1xServerRequest responseInProgress;
        Http1xServerRequest requestInProgress;
        ServerWebSocketImpl ws;
        super.handleException(t);
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.webSocket;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.requestFailed = true;
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(t);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(t);
        }
        if (ws != null) {
            ws.context.execute(v -> ws.handleException(t));
        }
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        ReferenceCountUtil.release(obj);
        this.fail(result.cause());
    }
}

