/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.BufferingWriteStream;
import io.vertx.httpproxy.impl.CacheControl;
import io.vertx.httpproxy.impl.HttpUtils;
import io.vertx.httpproxy.impl.ParseUtils;
import io.vertx.httpproxy.impl.ProxyRequestImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

class ProxyResponseImpl
implements ProxyResponse {
    private final ProxyRequestImpl request;
    private final HttpServerResponse outboundResponse;
    private int statusCode;
    private String statusMessage;
    private Body body;
    private final MultiMap headers;
    private HttpClientResponse inboundResponse;
    private long maxAge;
    private String etag;
    private boolean publicCacheControl;
    private Function<ReadStream<Buffer>, ReadStream<Buffer>> bodyFilter = Function.identity();

    ProxyResponseImpl(ProxyRequestImpl request, HttpServerResponse outboundResponse) {
        this.inboundResponse = null;
        this.statusCode = 200;
        this.headers = MultiMap.caseInsensitiveMultiMap();
        this.request = request;
        this.outboundResponse = outboundResponse;
    }

    ProxyResponseImpl(ProxyRequestImpl request, HttpServerResponse outboundResponse, HttpClientResponse inboundResponse) {
        CacheControl cacheControl;
        long contentLength = -1L;
        String contentLengthHeader = inboundResponse.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLengthHeader != null) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.request = request;
        this.inboundResponse = inboundResponse;
        this.outboundResponse = outboundResponse;
        this.statusCode = inboundResponse.statusCode();
        this.statusMessage = inboundResponse.statusMessage();
        this.body = Body.body(inboundResponse, contentLength);
        long maxAge = -1L;
        boolean publicCacheControl = false;
        String cacheControlHeader = inboundResponse.getHeader(HttpHeaders.CACHE_CONTROL);
        if (cacheControlHeader != null && (cacheControl = new CacheControl().parse(cacheControlHeader)).isPublic()) {
            publicCacheControl = true;
            if (cacheControl.maxAge() > 0) {
                maxAge = (long)cacheControl.maxAge() * 1000L;
            } else {
                String dateHeader = inboundResponse.getHeader(HttpHeaders.DATE);
                String expiresHeader = inboundResponse.getHeader(HttpHeaders.EXPIRES);
                if (dateHeader != null && expiresHeader != null) {
                    maxAge = ParseUtils.parseHeaderDate(expiresHeader).getTime() - ParseUtils.parseHeaderDate(dateHeader).getTime();
                }
            }
        }
        this.maxAge = maxAge;
        this.publicCacheControl = publicCacheControl;
        this.etag = inboundResponse.getHeader(HttpHeaders.ETAG);
        this.headers = MultiMap.caseInsensitiveMultiMap().addAll(inboundResponse.headers());
    }

    @Override
    public ProxyRequest request() {
        return this.request;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public ProxyResponse setStatusCode(int sc) {
        this.statusCode = sc;
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public ProxyResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public ProxyResponse setBody(Body body) {
        this.body = body;
        return this;
    }

    @Override
    public boolean publicCacheControl() {
        return this.publicCacheControl;
    }

    @Override
    public long maxAge() {
        return this.maxAge;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public ProxyResponse putHeader(CharSequence name, CharSequence value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public ProxyResponse bodyFilter(Function<ReadStream<Buffer>, ReadStream<Buffer>> filter) {
        this.bodyFilter = filter;
        return this;
    }

    @Override
    public Future<Void> send() {
        PromiseInternal<Void> promise = this.request.context.promise();
        this.send(promise);
        return promise.future();
    }

    public void send(Handler<AsyncResult<Void>> completionHandler) {
        Date date;
        this.outboundResponse.setStatusCode(this.statusCode);
        if (this.statusMessage != null) {
            this.outboundResponse.setStatusMessage(this.statusMessage);
        }
        if ((date = HttpUtils.dateHeader(this.headers)) == null) {
            date = new Date();
        }
        try {
            this.outboundResponse.putHeader("date", ParseUtils.formatHttpDate(date));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> warningHeaders = this.headers.getAll("warning");
        if (warningHeaders.size() > 0) {
            warningHeaders = new ArrayList<String>(warningHeaders);
            String dateHeader = this.headers.get("date");
            Date dateInstant = dateHeader != null ? ParseUtils.parseHeaderDate(dateHeader) : null;
            Iterator<String> i = warningHeaders.iterator();
            while (i.hasNext()) {
                String warningHeader = i.next();
                Date warningInstant = ParseUtils.parseWarningHeaderDate(warningHeader);
                if (warningInstant == null || dateInstant == null || warningInstant.equals(dateInstant)) continue;
                i.remove();
            }
        }
        this.outboundResponse.putHeader("warning", warningHeaders);
        this.headers.forEach(header -> {
            String name = (String)header.getKey();
            String value = (String)header.getValue();
            if (!(name.equalsIgnoreCase("date") || name.equalsIgnoreCase("warning") || name.equalsIgnoreCase("transfer-encoding"))) {
                this.outboundResponse.headers().add(name, value);
            }
        });
        if (this.body == null) {
            this.outboundResponse.end();
            return;
        }
        long len2 = this.body.length();
        if (len2 >= 0L) {
            this.outboundResponse.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(len2));
        } else {
            if (this.request.outboundRequest().version() == HttpVersion.HTTP_1_0) {
                BufferingWriteStream buffer = new BufferingWriteStream();
                this.body.stream().pipeTo(buffer, ar -> {
                    if (ar.succeeded()) {
                        Buffer content = buffer.content();
                        this.outboundResponse.end(content, completionHandler);
                    } else {
                        System.out.println("Not implemented");
                    }
                });
                return;
            }
            this.outboundResponse.setChunked(true);
        }
        ReadStream<Buffer> bodyStream = this.bodyFilter.apply(this.body.stream());
        this.sendResponse(bodyStream, completionHandler);
    }

    @Override
    public ProxyResponse release() {
        if (this.inboundResponse != null) {
            this.inboundResponse.resume();
            this.inboundResponse = null;
            this.body = null;
            this.headers.clear();
        }
        return this;
    }

    private void sendResponse(ReadStream<Buffer> body, Handler<AsyncResult<Void>> completionHandler) {
        Pipe<Buffer> pipe = body.pipe();
        pipe.endOnSuccess(true);
        pipe.endOnFailure(false);
        pipe.to(this.outboundResponse, ar -> {
            if (ar.failed()) {
                this.request.inboundRequest.reset();
                this.outboundResponse.reset();
            }
            completionHandler.handle((AsyncResult<Void>)ar);
        });
    }
}

