/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.emqx;

import cc.iotkit.common.thing.ThingService;
import cc.iotkit.comp.emqx.IScripter;
import cc.iotkit.comp.emqx.JsScripter;
import cc.iotkit.comp.emqx.LuaScripter;
import cc.iotkit.comp.emqx.TransparentMsg;
import cc.iotkit.comp.utils.SpringUtils;
import cc.iotkit.converter.Device;
import cc.iotkit.converter.DeviceMessage;
import cc.iotkit.data.IDeviceInfoData;
import cc.iotkit.data.IProductModelData;
import cc.iotkit.model.device.DeviceInfo;
import cc.iotkit.model.device.message.ThingModelMessage;
import cc.iotkit.model.product.ProductModel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransparentConverter {
    private static final Logger log = LoggerFactory.getLogger(TransparentConverter.class);
    private final Map<String, IScripter> scripters = new HashMap<String, IScripter>();
    private final Map<String, String> scripts = new HashMap<String, String>();
    private IDeviceInfoData deviceInfoData;
    private IProductModelData productModelData;

    public ThingModelMessage decode(TransparentMsg msg) {
        String productKey = this.checkScriptUpdate(msg.getModel());
        msg.setProductKey(productKey);
        return this.scripters.get(productKey).decode(msg);
    }

    public DeviceMessage encode(ThingService<?> service, Device device) {
        String productKey = service.getProductKey();
        this.checkScriptUpdate(device.getModel());
        TransparentMsg transparentMsg = this.scripters.get(productKey).encode(service);
        String deviceName = service.getDeviceName();
        DeviceInfo gateway = this.getGatewayInfo(productKey, deviceName);
        DeviceMessage message = new DeviceMessage();
        message.setProductKey(gateway.getProductKey());
        message.setDeviceName(gateway.getDeviceName());
        message.setMid(transparentMsg.getMid());
        message.setContent((Object)transparentMsg);
        return message;
    }

    private ProductModel getScript(String model) {
        if (this.productModelData == null) {
            this.productModelData = (IProductModelData)SpringUtils.getBean((String)"productModelDataCache");
        }
        return this.productModelData.findByModel(model);
    }

    private DeviceInfo getGatewayInfo(String subPk, String subDn) {
        if (this.deviceInfoData == null) {
            this.deviceInfoData = (IDeviceInfoData)SpringUtils.getBean((String)"deviceInfoDataCache");
        }
        String parentId = this.deviceInfoData.findByProductKeyAndDeviceName(subPk, subDn).getParentId();
        return this.deviceInfoData.findByDeviceId(parentId);
    }

    private String checkScriptUpdate(String model) {
        String oldScript;
        ProductModel productModel = this.getScript(model);
        String productKey = productModel.getProductKey();
        String script = productModel.getScript();
        if (script.equals(oldScript = this.scripts.get(productKey))) {
            return productKey;
        }
        String type2 = productModel.getType();
        if ("LuaScript".equals(type2)) {
            this.scripters.putIfAbsent(productKey, new LuaScripter());
        } else if ("JavaScript".equals(type2)) {
            this.scripters.putIfAbsent(productKey, new JsScripter());
        }
        IScripter scripter = this.scripters.get(productKey);
        scripter.setScript(script);
        this.scripts.put(productKey, script);
        return productKey;
    }
}

