/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentCyclicSequence<T>
implements Iterable<T>,
Iterator<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final AtomicInteger pos;
    private final Object[] elements;

    public ConcurrentCyclicSequence() {
        this(0, EMPTY_ARRAY);
    }

    @SafeVarargs
    public ConcurrentCyclicSequence(T ... elements) {
        this(0, (Object[])Arrays.copyOf(elements, elements.length, Object[].class));
    }

    private ConcurrentCyclicSequence(int pos, Object[] elements) {
        this.pos = new AtomicInteger(pos);
        this.elements = elements;
    }

    public int index() {
        return this.elements.length > 0 ? this.pos.get() % this.elements.length : 0;
    }

    public T first() {
        return (T)(this.elements.length > 0 ? this.elements[0] : null);
    }

    public ConcurrentCyclicSequence<T> add(T element) {
        int len2 = this.elements.length;
        Object[] copy = Arrays.copyOf(this.elements, len2 + 1);
        copy[len2] = element;
        return new ConcurrentCyclicSequence<T>(this.pos.get(), copy);
    }

    public ConcurrentCyclicSequence<T> remove(T element) {
        int len2 = this.elements.length;
        for (int i = 0; i < len2; ++i) {
            if (!Objects.equals(element, this.elements[i])) continue;
            if (len2 > 1) {
                Object[] copy = new Object[len2 - 1];
                System.arraycopy(this.elements, 0, copy, 0, i);
                System.arraycopy(this.elements, i + 1, copy, i, len2 - i - 1);
                return new ConcurrentCyclicSequence<T>(this.pos.get() % copy.length, copy);
            }
            return new ConcurrentCyclicSequence<T>();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        int len2 = this.elements.length;
        switch (len2) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)this.elements[0];
            }
        }
        int p = this.pos.getAndIncrement();
        return (T)this.elements[Math.abs(p % len2)];
    }

    public int size() {
        return this.elements.length;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.elements).iterator();
    }
}

