/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.emqx;

import cc.iotkit.common.thing.ThingService;
import cc.iotkit.comp.emqx.IScripter;
import cc.iotkit.comp.emqx.TransparentMsg;
import cc.iotkit.model.device.message.ThingModelMessage;
import cc.iotkit.model.product.ProductModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.beanutils.BeanUtils;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.script.LuaScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuaScripter
implements IScripter {
    private static final Logger log = LoggerFactory.getLogger(LuaScripter.class);
    private ProductModel model;
    private final LuaScriptEngine engine = (LuaScriptEngine)new ScriptEngineManager().getEngineByName("luaj");
    private LuaValue decoder;
    private LuaValue encoder;

    public LuaScripter(ProductModel model) {
        this.model = model;
    }

    @Override
    public void setScript(String script) {
        try {
            CompiledScript compiledScript = this.engine.compile(script);
            SimpleBindings bindings = new SimpleBindings();
            compiledScript.eval(bindings);
            this.decoder = (LuaValue)bindings.get("decode");
            this.encoder = (LuaValue)bindings.get("encode");
        }
        catch (Throwable e) {
            log.error("compile script error", e);
        }
    }

    @Override
    public ThingModelMessage decode(TransparentMsg msg) {
        try {
            LuaTable table = new LuaTable();
            table.set("model", msg.getModel());
            table.set("deviceName", msg.getDeviceName());
            table.set("data", msg.getData());
            Map result = (Map)this.parse(this.decoder.call(table));
            ThingModelMessage modelMessage = new ThingModelMessage();
            BeanUtils.populate((Object)modelMessage, (Map)result);
            modelMessage.setProductKey(msg.getProductKey());
            modelMessage.setDeviceName(msg.getDeviceName());
            return modelMessage;
        }
        catch (Throwable e) {
            log.error("execute decode script error", e);
            return null;
        }
    }

    @Override
    public TransparentMsg encode(ThingService<?> service) {
        try {
            LuaTable table = new LuaTable();
            table.set("identifier", service.getIdentifier());
            table.set("type", service.getType());
            table.set("productKey", service.getProductKey());
            table.set("deviceName", service.getDeviceName());
            table.set("mid", service.getMid());
            Object params = service.getParams();
            LuaTable tableParams = new LuaTable();
            if (params instanceof Map) {
                ((Map)params).forEach((key, val) -> tableParams.set(key.toString(), this.parse(val)));
            }
            table.set("params", (LuaValue)tableParams);
            LuaValue result = this.encoder.call(table);
            Map map = (Map)this.parse(result);
            TransparentMsg message = new TransparentMsg();
            BeanUtils.populate((Object)message, (Map)map);
            message.setProductKey(this.model.getProductKey());
            message.setModel(this.model.getModel());
            message.setDeviceName(service.getDeviceName());
            return message;
        }
        catch (Throwable e) {
            log.error("execute encode script error", e);
            return null;
        }
    }

    private Object parse(LuaValue value) {
        String type2;
        switch (type2 = value.typename()) {
            case "string": {
                return value.toString();
            }
            case "number": 
            case "int": {
                return value.toint();
            }
            case "table": {
                HashMap<String, Object> data = new HashMap<String, Object>();
                LuaTable table = (LuaTable)value;
                int arrLen = table.rawlen();
                if (arrLen > 0) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (LuaValue key : table.keys()) {
                        list.add(this.parse(table.get(key)));
                    }
                    return list;
                }
                for (LuaValue key : table.keys()) {
                    data.put(key.toString(), this.parse(table.get(key)));
                }
                return data;
            }
        }
        return null;
    }

    private LuaValue parse(Object value) {
        if (value instanceof String) {
            return LuaValue.valueOf(value.toString());
        }
        if (value instanceof Integer) {
            return LuaValue.valueOf((Integer)value);
        }
        return new LuaTable();
    }

    public ProductModel getModel() {
        return this.model;
    }

    public LuaScriptEngine getEngine() {
        return this.engine;
    }

    public LuaValue getDecoder() {
        return this.decoder;
    }

    public LuaValue getEncoder() {
        return this.encoder;
    }

    public void setModel(ProductModel model) {
        this.model = model;
    }

    public void setDecoder(LuaValue decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(LuaValue encoder) {
        this.encoder = encoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LuaScripter)) {
            return false;
        }
        LuaScripter other = (LuaScripter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProductModel this$model = this.getModel();
        ProductModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        LuaScriptEngine this$engine = this.getEngine();
        LuaScriptEngine other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        LuaValue this$decoder = this.getDecoder();
        LuaValue other$decoder = other.getDecoder();
        if (this$decoder == null ? other$decoder != null : !((Object)this$decoder).equals(other$decoder)) {
            return false;
        }
        LuaValue this$encoder = this.getEncoder();
        LuaValue other$encoder = other.getEncoder();
        return !(this$encoder == null ? other$encoder != null : !((Object)this$encoder).equals(other$encoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LuaScripter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProductModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        LuaScriptEngine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        LuaValue $decoder = this.getDecoder();
        result = result * 59 + ($decoder == null ? 43 : $decoder.hashCode());
        LuaValue $encoder = this.getEncoder();
        result = result * 59 + ($encoder == null ? 43 : $encoder.hashCode());
        return result;
    }

    public String toString() {
        return "LuaScripter(model=" + this.getModel() + ", engine=" + this.getEngine() + ", decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ")";
    }
}

