/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core.http;

import org.apache.http.entity.ContentType;

public class RequestFormat {
    private String name;
    private ContentType contentType;

    public static RequestFormat GET() {
        return RequestFormat.type("GET");
    }

    public static RequestFormat POST() {
        return RequestFormat.type("POST");
    }

    public static RequestFormat PUT() {
        return RequestFormat.type("PUT");
    }

    public static RequestFormat PATCH() {
        return RequestFormat.type("PATCH");
    }

    public static RequestFormat DELETE() {
        return RequestFormat.type("DELETE");
    }

    public static RequestFormat type(String method) {
        return RequestFormat.type(method, ContentType.create((String)ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), (String)"utf-8"));
    }

    public static RequestFormat type(String method, String contentType) {
        return RequestFormat.type(method, ContentType.parse((String)contentType));
    }

    public static RequestFormat type(String method, ContentType contentType) {
        return RequestFormat.type(method, contentType, null);
    }

    public static RequestFormat type(String method, ContentType contentType, String charset) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("ContentType cannot be null");
        }
        if (charset != null) {
            contentType = ContentType.create((String)contentType.getMimeType(), (String)charset);
        }
        method = method.toUpperCase();
        RequestFormat type = new RequestFormat(method, contentType);
        return type;
    }

    private RequestFormat(String name, ContentType contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public RequestFormat name(String name) {
        this.name = name;
        return this;
    }

    public RequestFormat contentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestFormat contentType(ContentType contentType, String charset) {
        if (charset != null) {
            contentType = ContentType.create((String)contentType.getMimeType(), (String)charset);
        }
        this.contentType = contentType;
        return this;
    }

    public int hashCode() {
        return this.name.hashCode() + this.contentType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestFormat)) {
            return false;
        }
        return this.name.equals(((RequestFormat)obj).name) && this.contentType.equals(((RequestFormat)obj).contentType);
    }

    public String toString() {
        return this.name + ": " + this.contentType;
    }
}

