/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;

class BufferingReadStream
implements ReadStream<Buffer> {
    private final ReadStream<Buffer> stream;
    private final Buffer content;

    public BufferingReadStream(ReadStream<Buffer> stream, Buffer content) {
        this.stream = stream;
        this.content = content;
    }

    @Override
    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.stream.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        if (handler != null) {
            this.stream.handler((T buff) -> {
                this.content.appendBuffer((Buffer)buff);
                handler.handle((Buffer)buff);
            });
        } else {
            this.stream.handler(null);
        }
        return this;
    }

    @Override
    public ReadStream<Buffer> pause() {
        this.stream.pause();
        return this;
    }

    @Override
    public ReadStream<Buffer> resume() {
        this.stream.resume();
        return this;
    }

    @Override
    public ReadStream<Buffer> fetch(long amount) {
        this.stream.fetch(amount);
        return this;
    }

    @Override
    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        if (endHandler != null) {
            this.stream.endHandler(v -> endHandler.handle(null));
        } else {
            this.stream.endHandler(null);
        }
        return this;
    }
}

