/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.MaxMessagesRecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramPacketImpl;
import io.vertx.core.datagram.impl.PacketWriteStreamImpl;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.WriteStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Objects;

public class DatagramSocketImpl
implements DatagramSocket,
MetricsProvider {
    private final ContextInternal context;
    private final DatagramSocketMetrics metrics;
    private DatagramChannel channel;
    private Handler<DatagramPacket> packetHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private long demand;

    public static DatagramSocketImpl create(VertxInternal vertx, DatagramSocketOptions options) {
        DatagramSocketImpl socket = new DatagramSocketImpl(vertx, options);
        socket.init();
        return socket;
    }

    private DatagramSocketImpl(VertxInternal vertx, DatagramSocketOptions options) {
        VertxMetrics metrics;
        Transport transport = vertx.transport();
        DatagramChannel channel = transport.datagramChannel(options.isIpV6() ? InternetProtocolFamily.IPv6 : InternetProtocolFamily.IPv4);
        transport.configure(channel, new DatagramSocketOptions(options));
        ContextInternal context = vertx.getOrCreateContext();
        channel.config().setOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        MaxMessagesRecvByteBufAllocator bufAllocator = (MaxMessagesRecvByteBufAllocator)channel.config().getRecvByteBufAllocator();
        bufAllocator.maxMessagesPerRead(1);
        context.nettyEventLoop().register(channel);
        if (options.getLogActivity()) {
            channel.pipeline().addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        this.metrics = (metrics = vertx.metricsSPI()) != null ? metrics.createDatagramSocketMetrics(options) : null;
        this.channel = channel;
        this.context = context;
        this.demand = Long.MAX_VALUE;
    }

    private void init() {
        this.channel.pipeline().addLast("handler", VertxHandler.create(this::createConnection));
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.listenMulticastGroup(multicastAddress);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    private NetworkInterface determineMulticastNetworkIface() throws Exception {
        NetworkInterface iface = null;
        InetSocketAddress localAddr = this.channel.localAddress();
        if (localAddr != null) {
            iface = NetworkInterface.getByInetAddress(localAddr.getAddress());
        }
        if (iface == null) {
            iface = this.channel.config().getNetworkInterface();
        }
        return iface;
    }

    @Override
    public Future<Void> listenMulticastGroup(String multicastAddress) {
        ChannelFuture fut;
        NetworkInterface iface;
        try {
            iface = this.determineMulticastNetworkIface();
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        if (iface == null) {
            return this.context.failedFuture("A valid network interface could not be determined from the socket bind address or multicast interface");
        }
        try {
            fut = this.channel.joinGroup(InetAddress.getByName(multicastAddress), iface, null);
        }
        catch (UnknownHostException e) {
            return this.context.failedFuture(e);
        }
        PromiseInternal promise = this.context.promise();
        fut.addListener(promise);
        return promise.future();
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.listenMulticastGroup(multicastAddress, networkInterface, source);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> listenMulticastGroup(String multicastAddress, String networkInterface, @Nullable String source) {
        ChannelFuture fut;
        try {
            InetAddress sourceAddress = source == null ? null : InetAddress.getByName(source);
            fut = this.channel.joinGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress);
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        PromiseInternal promise = this.context.promise();
        fut.addListener(promise);
        return promise.future();
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.unlistenMulticastGroup(multicastAddress);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> unlistenMulticastGroup(String multicastAddress) {
        ChannelFuture fut;
        NetworkInterface iface;
        try {
            iface = this.determineMulticastNetworkIface();
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        if (iface == null) {
            return this.context.failedFuture("A valid network interface could not be determined from the socket bind address or multicast interface");
        }
        try {
            fut = this.channel.leaveGroup(InetAddress.getByName(multicastAddress), iface, null);
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        PromiseInternal promise = this.context.promise();
        fut.addListener(promise);
        return promise.future();
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.unlistenMulticastGroup(multicastAddress, networkInterface, source);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> unlistenMulticastGroup(String multicastAddress, String networkInterface, @Nullable String source) {
        ChannelFuture fut;
        try {
            InetAddress sourceAddress = source == null ? null : InetAddress.getByName(source);
            fut = this.channel.leaveGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress);
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        PromiseInternal promise = this.context.promise();
        fut.addListener(promise);
        return promise.future();
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        ChannelFuture fut;
        try {
            InetAddress sourceAddress = sourceToBlock == null ? null : InetAddress.getByName(sourceToBlock);
            fut = this.channel.block(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress);
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        PromiseInternal promise = this.context.promise();
        fut.addListener(promise);
        return promise.future();
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.blockMulticastGroup(multicastAddress, sourceToBlock);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        ChannelFuture fut;
        try {
            fut = this.channel.block(InetAddress.getByName(multicastAddress), InetAddress.getByName(sourceToBlock));
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        PromiseInternal promise = this.context.promise();
        fut.addListener(promise);
        return promise.future();
    }

    @Override
    public DatagramSocket listen(int port, String address, Handler<AsyncResult<DatagramSocket>> handler) {
        Objects.requireNonNull(handler, "no null handler accepted");
        this.listen(SocketAddress.inetSocketAddress(port, address)).onComplete(handler);
        return this;
    }

    @Override
    public Future<DatagramSocket> listen(int port, String address) {
        return this.listen(SocketAddress.inetSocketAddress(port, address));
    }

    @Override
    public synchronized DatagramSocket handler(Handler<DatagramPacket> handler) {
        this.packetHandler = handler;
        return this;
    }

    @Override
    public DatagramSocketImpl endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public DatagramSocketImpl exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private Future<DatagramSocket> listen(SocketAddress local) {
        AddressResolver resolver = this.context.owner().addressResolver();
        PromiseInternal promise = this.context.promise();
        io.netty.util.concurrent.Future<InetSocketAddress> f1 = resolver.resolveHostname(this.context.nettyEventLoop(), local.host());
        f1.addListener(res1 -> {
            if (res1.isSuccess()) {
                ChannelFuture f2 = this.channel.bind(new InetSocketAddress(((InetSocketAddress)res1.getNow()).getAddress(), local.port()));
                if (this.metrics != null) {
                    f2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)res2 -> {
                        if (res2.isSuccess()) {
                            this.metrics.listening(local.host(), this.localAddress());
                        }
                    }));
                }
                f2.addListener(promise);
            } else {
                promise.fail(res1.cause());
            }
        });
        return promise.future().map(this);
    }

    @Override
    public synchronized DatagramSocket pause() {
        if (this.demand > 0L) {
            this.demand = 0L;
            this.channel.config().setAutoRead(false);
        }
        return this;
    }

    @Override
    public synchronized DatagramSocket resume() {
        if (this.demand == 0L) {
            this.demand = Long.MAX_VALUE;
            this.channel.config().setAutoRead(true);
        }
        return this;
    }

    @Override
    public synchronized DatagramSocket fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Illegal fetch " + amount);
        }
        if (amount > 0L) {
            if (this.demand == 0L) {
                this.channel.config().setAutoRead(true);
            }
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
        }
        return this;
    }

    @Override
    public DatagramSocket send(Buffer packet, int port, String host, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.send(packet, port, host);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> send(Buffer packet, int port, String host) {
        Objects.requireNonNull(packet, "no null packet accepted");
        Objects.requireNonNull(host, "no null host accepted");
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        AddressResolver resolver = this.context.owner().addressResolver();
        PromiseInternal promise = this.context.promise();
        io.netty.util.concurrent.Future<InetSocketAddress> f1 = resolver.resolveHostname(this.context.nettyEventLoop(), host);
        f1.addListener(res1 -> {
            if (res1.isSuccess()) {
                ChannelFuture f2 = this.channel.writeAndFlush(new io.netty.channel.socket.DatagramPacket(packet.getByteBuf(), new InetSocketAddress(((InetSocketAddress)f1.getNow()).getAddress(), port)));
                if (this.metrics != null) {
                    f2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> {
                        if (fut.isSuccess()) {
                            this.metrics.bytesWritten(null, SocketAddress.inetSocketAddress(port, host), packet.length());
                        }
                    }));
                }
                f2.addListener(promise);
            } else {
                promise.fail(res1.cause());
            }
        });
        return promise.future();
    }

    @Override
    public WriteStream<Buffer> sender(int port, String host) {
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        Objects.requireNonNull(host, "no null host accepted");
        return new PacketWriteStreamImpl(this, port, host);
    }

    @Override
    public DatagramSocket send(String str, int port, String host, Handler<AsyncResult<Void>> handler) {
        return this.send(Buffer.buffer(str), port, host, handler);
    }

    @Override
    public Future<Void> send(String str, int port, String host) {
        return this.send(Buffer.buffer(str), port, host);
    }

    @Override
    public DatagramSocket send(String str, String enc, int port, String host, Handler<AsyncResult<Void>> handler) {
        return this.send(Buffer.buffer(str, enc), port, host, handler);
    }

    @Override
    public Future<Void> send(String str, String enc, int port, String host) {
        return this.send(Buffer.buffer(str, enc), port, host);
    }

    @Override
    public SocketAddress localAddress() {
        return this.context.owner().transport().convert(this.channel.localAddress());
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        Future<Void> future = this.close();
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    @Override
    public synchronized Future<Void> close() {
        if (!this.channel.isOpen()) {
            return this.context.succeededFuture();
        }
        this.channel.flush();
        ChannelFuture future = this.channel.close();
        PromiseInternal promise = this.context.promise();
        future.addListener(promise);
        return promise.future();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private Connection createConnection(ChannelHandlerContext chctx) {
        return new Connection(this.context, chctx);
    }

    class Connection
    extends ConnectionBase {
        public Connection(ContextInternal context, ChannelHandlerContext channel) {
            super(context, channel);
        }

        @Override
        public NetworkMetrics metrics() {
            return DatagramSocketImpl.this.metrics;
        }

        @Override
        protected void handleInterestedOpsChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleException(Throwable t) {
            Handler handler;
            super.handleException(t);
            DatagramSocketImpl datagramSocketImpl = DatagramSocketImpl.this;
            synchronized (datagramSocketImpl) {
                handler = DatagramSocketImpl.this.exceptionHandler;
            }
            if (handler != null) {
                handler.handle(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleClosed() {
            DatagramSocketMetrics metrics;
            Handler handler;
            super.handleClosed();
            DatagramSocketImpl datagramSocketImpl = DatagramSocketImpl.this;
            synchronized (datagramSocketImpl) {
                handler = DatagramSocketImpl.this.endHandler;
                metrics = DatagramSocketImpl.this.metrics;
            }
            if (metrics != null) {
                metrics.close();
            }
            if (handler != null) {
                this.context.emit(null, handler);
            }
        }

        @Override
        public void handleMessage(Object msg) {
            if (msg instanceof io.netty.channel.socket.DatagramPacket) {
                io.netty.channel.socket.DatagramPacket packet = (io.netty.channel.socket.DatagramPacket)msg;
                ByteBuf content = (ByteBuf)packet.content();
                if (content.isDirect()) {
                    content = VertxHandler.safeBuffer(content);
                }
                this.handlePacket(new DatagramPacketImpl((InetSocketAddress)packet.sender(), Buffer.buffer(content)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handlePacket(DatagramPacket packet) {
            Handler handler;
            DatagramSocketImpl datagramSocketImpl = DatagramSocketImpl.this;
            synchronized (datagramSocketImpl) {
                if (DatagramSocketImpl.this.metrics != null) {
                    DatagramSocketImpl.this.metrics.bytesRead(null, packet.sender(), packet.data().length());
                }
                if (DatagramSocketImpl.this.demand > 0L) {
                    if (DatagramSocketImpl.this.demand != Long.MAX_VALUE) {
                        DatagramSocketImpl.this.demand--;
                    }
                    handler = DatagramSocketImpl.this.packetHandler;
                } else {
                    handler = null;
                }
            }
            if (handler != null) {
                this.context.emit(packet, handler);
            }
        }
    }
}

