/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.utils;

public class ByteUtils {
    public static byte hex2byte(String hex) {
        return Integer.valueOf(hex, 16).byteValue();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        String string = hexString.replaceAll(" ", "");
        byte[] byteArray = new byte[string.length() / 2];
        int pos = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(string.charAt(pos), 16) & 0xFF);
            byte low = (byte)(Character.digit(string.charAt(pos + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            pos += 2;
        }
        return byteArray;
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        return ByteUtils.byteArrayToHexString(byteArray, true);
    }

    public static String byteArrayToHexString(byte[] byteArray, boolean blankz) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
            if (!blankz) continue;
            hexString.append(" ");
        }
        return hexString.toString();
    }

    public static void byteInvertedOrder(byte[] tmp, byte[] retData) {
        System.arraycopy(tmp, 0, retData, 0, Math.min(tmp.length, retData.length));
        for (int i = 0; i < retData.length / 2; ++i) {
            byte by = retData[i];
            retData[i] = retData[5 - i];
            retData[5 - i] = by;
        }
    }
}

