/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.websocket.client;

import cc.iotkit.common.enums.ErrCode;
import cc.iotkit.common.exception.BizException;
import cc.iotkit.common.utils.JsonUtils;
import cc.iotkit.comp.model.ReceiveResult;
import cc.iotkit.comp.model.RegisterInfo;
import cc.iotkit.comp.websocket.AbstractDeviceVerticle;
import cc.iotkit.comp.websocket.client.WebSocketClientConfig;
import cc.iotkit.converter.DeviceMessage;
import io.vertx.core.Future;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientVerticle
extends AbstractDeviceVerticle {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientVerticle.class);
    private HttpClient httpClient;
    private WebSocket webSocketClient;
    private WebSocketClientConfig webSocketConfig;
    private long timerID;
    private final Map<String, Device> devices = new ConcurrentHashMap<String, Device>();

    public void setWebSocketClient(WebSocket webSocketClient) {
        this.webSocketClient = webSocketClient;
    }

    public WebSocketClientVerticle(String config) {
        this.webSocketConfig = (WebSocketClientConfig)JsonUtils.parseObject((String)config, WebSocketClientConfig.class);
    }

    @Override
    public void start() {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(this.webSocketConfig.getPort()).setHost(this.webSocketConfig.getIp()).setURI(this.webSocketConfig.getUrl()).setSsl(this.webSocketConfig.isSsl());
        this.httpClient = this.vertx.createHttpClient();
        this.httpClient.webSocket(options).onSuccess(ws -> {
            this.setWebSocketClient((WebSocket)ws);
            log.info("webSocket client connect success!");
            ws.textMessageHandler(data -> {
                log.info("webSocket client receive msg:" + data);
                this.executor.onReceive(new HashMap(), null, data, ret -> {
                    if (ret != null && ret.getData() instanceof RegisterInfo) {
                        this.executor.onReceive(null, "connected", data, r -> {
                            if (!this.devices.containsKey(this.getDeviceKey((ReceiveResult)r))) {
                                this.devices.put(this.getDeviceKey((ReceiveResult)r), new Device(r.getDeviceName(), r.getProductKey()));
                            }
                        });
                    }
                });
            });
            ws.closeHandler(e -> {
                for (String deviceKey : this.devices.keySet()) {
                    this.executor.onReceive(null, "disconnect", deviceKey);
                }
                log.warn("client connection closed!");
            });
            ws.exceptionHandler(e -> {
                for (String deviceKey : this.devices.keySet()) {
                    this.executor.onReceive(null, "disconnect", deviceKey);
                }
                log.error("webSocket client connect exception!");
            });
            if (this.webSocketConfig.getHeartBeatTime() > 0L && StringUtils.isNotBlank((CharSequence)this.webSocketConfig.getHeartBeatData())) {
                this.timerID = this.vertx.setPeriodic(this.webSocketConfig.getHeartBeatTime(), t -> {
                    if (this.webSocketClient.isClosed()) {
                        this.vertx.cancelTimer(this.timerID);
                    }
                    this.executor.onReceive(new HashMap(), "ping", JsonUtils.toJsonString((Object)this.webSocketConfig));
                });
            }
        }).onFailure(e -> log.info("webSocket client connect failed!"));
    }

    @Override
    public void stop() {
        this.vertx.cancelTimer(this.timerID);
        for (String deviceKey : this.devices.keySet()) {
            this.executor.onReceive(null, "disconnect", deviceKey);
        }
        this.httpClient.close();
    }

    @Override
    public DeviceMessage send(DeviceMessage message) {
        Object obj = message.getContent();
        if (!(obj instanceof Map)) {
            throw new BizException(ErrCode.DATA_FORMAT_ERROR);
        }
        String msgStr = JsonUtils.toJsonString((Object)obj);
        log.info("send msg payload:{}", (Object)msgStr);
        Future<Void> result = this.webSocketClient.writeTextMessage(msgStr);
        result.onFailure(e -> log.error("webSocket client send msg failed", e));
        return message;
    }

    private String getDeviceKey(ReceiveResult result) {
        return this.getDeviceKey(result.getProductKey(), result.getDeviceName());
    }

    private String getDeviceKey(String productKey, String deviceName) {
        return String.format("%s_%s", productKey, deviceName);
    }

    public static class Device {
        private String productKey;
        private String deviceName;

        public String getProductKey() {
            return this.productKey;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setProductKey(String productKey) {
            this.productKey = productKey;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Device)) {
                return false;
            }
            Device other = (Device)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$productKey = this.getProductKey();
            String other$productKey = other.getProductKey();
            if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
                return false;
            }
            String this$deviceName = this.getDeviceName();
            String other$deviceName = other.getDeviceName();
            return !(this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Device;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $productKey = this.getProductKey();
            result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
            String $deviceName = this.getDeviceName();
            result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
            return result;
        }

        public Device() {
        }

        public Device(String productKey, String deviceName) {
            this.productKey = productKey;
            this.deviceName = deviceName;
        }

        public String toString() {
            return "WebSocketClientVerticle.Device(productKey=" + this.getProductKey() + ", deviceName=" + this.getDeviceName() + ")";
        }
    }
}

