/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.util.List;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.FuncName;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.SyntaxElement;
import org.luaj.vm2.ast.Visitor;

public abstract class Stat
extends SyntaxElement {
    public abstract void accept(Visitor var1);

    public static Stat block(Block block) {
        return block;
    }

    public static Stat whiledo(Exp exp2, Block block) {
        return new WhileDo(exp2, block);
    }

    public static Stat repeatuntil(Block block, Exp exp2) {
        return new RepeatUntil(block, exp2);
    }

    public static Stat breakstat() {
        return new Break();
    }

    public static Stat returnstat(List list) {
        return new Return(list);
    }

    public static Stat assignment(List list, List list2) {
        return new Assign(list, list2);
    }

    public static Stat functioncall(Exp.FuncCall funcCall) {
        return new FuncCallStat(funcCall);
    }

    public static Stat localfunctiondef(String string, FuncBody funcBody) {
        return new LocalFuncDef(string, funcBody);
    }

    public static Stat fornumeric(String string, Exp exp2, Exp exp3, Exp exp4, Block block) {
        return new NumericFor(string, exp2, exp3, exp4, block);
    }

    public static Stat functiondef(FuncName funcName, FuncBody funcBody) {
        return new FuncDef(funcName, funcBody);
    }

    public static Stat forgeneric(List list, List list2, Block block) {
        return new GenericFor(list, list2, block);
    }

    public static Stat localassignment(List list, List list2) {
        return new LocalAssign(list, list2);
    }

    public static Stat ifthenelse(Exp exp2, Block block, List list, List list2, Block block2) {
        return new IfThenElse(exp2, block, list, list2, block2);
    }

    public static Stat gotostat(String string) {
        return new Goto(string);
    }

    public static Stat labelstat(String string) {
        return new Label(string);
    }

    public static class IfThenElse
    extends Stat {
        public final Exp ifexp;
        public final Block ifblock;
        public final List elseifexps;
        public final List elseifblocks;
        public final Block elseblock;

        public IfThenElse(Exp exp2, Block block, List list, List list2, Block block2) {
            this.ifexp = exp2;
            this.ifblock = block;
            this.elseifexps = list;
            this.elseifblocks = list2;
            this.elseblock = block2;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class LocalAssign
    extends Stat {
        public final List names;
        public final List values;

        public LocalAssign(List list, List list2) {
            this.names = list;
            this.values = list2;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NumericFor
    extends Stat {
        public final Name name;
        public final Exp initial;
        public final Exp limit;
        public final Exp step;
        public final Block block;
        public NameScope scope;

        public NumericFor(String string, Exp exp2, Exp exp3, Exp exp4, Block block) {
            this.name = new Name(string);
            this.initial = exp2;
            this.limit = exp3;
            this.step = exp4;
            this.block = block;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class GenericFor
    extends Stat {
        public List names;
        public List exps;
        public Block block;
        public NameScope scope;

        public GenericFor(List list, List list2, Block block) {
            this.names = list;
            this.exps = list2;
            this.block = block;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FuncDef
    extends Stat {
        public final FuncName name;
        public final FuncBody body;

        public FuncDef(FuncName funcName, FuncBody funcBody) {
            this.name = funcName;
            this.body = funcBody;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class LocalFuncDef
    extends Stat {
        public final Name name;
        public final FuncBody body;

        public LocalFuncDef(String string, FuncBody funcBody) {
            this.name = new Name(string);
            this.body = funcBody;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FuncCallStat
    extends Stat {
        public final Exp.FuncCall funccall;

        public FuncCallStat(Exp.FuncCall funcCall) {
            this.funccall = funcCall;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Return
    extends Stat {
        public final List values;

        public Return(List list) {
            this.values = list;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public int nreturns() {
            int n;
            int n2 = n = this.values != null ? this.values.size() : 0;
            if (n > 0 && ((Exp)this.values.get(n - 1)).isvarargexp()) {
                n = -1;
            }
            return n;
        }
    }

    public static class Break
    extends Stat {
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class RepeatUntil
    extends Stat {
        public final Block block;
        public final Exp exp;

        public RepeatUntil(Block block, Exp exp2) {
            this.block = block;
            this.exp = exp2;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class WhileDo
    extends Stat {
        public final Exp exp;
        public final Block block;

        public WhileDo(Exp exp2, Block block) {
            this.exp = exp2;
            this.block = block;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Assign
    extends Stat {
        public final List vars;
        public final List exps;

        public Assign(List list, List list2) {
            this.vars = list;
            this.exps = list2;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Label
    extends Stat {
        public final String name;

        public Label(String string) {
            this.name = string;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Goto
    extends Stat {
        public final String name;

        public Goto(String string) {
            this.name = string;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }
}

