/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.streams.ReadStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.ProxyRequestImpl;
import java.util.function.Function;

@VertxGen
public interface ProxyRequest {
    public static ProxyRequest reverseProxy(HttpServerRequest outboundRequest) {
        outboundRequest.pause();
        return new ProxyRequestImpl(outboundRequest);
    }

    public HttpVersion version();

    public String absoluteURI();

    public HttpMethod getMethod();

    @Fluent
    public ProxyRequest setMethod(HttpMethod var1);

    public String getURI();

    @Fluent
    public ProxyRequest setURI(String var1);

    public Body getBody();

    @Fluent
    public ProxyRequest setBody(Body var1);

    public MultiMap headers();

    @GenIgnore
    @Fluent
    public ProxyRequest putHeader(CharSequence var1, CharSequence var2);

    @Fluent
    public ProxyRequest bodyFilter(Function<ReadStream<Buffer>, ReadStream<Buffer>> var1);

    default public Future<Void> proxy(HttpClientRequest inboundRequest) {
        return this.send(inboundRequest).flatMap(resp -> resp.send());
    }

    public Future<ProxyResponse> send(HttpClientRequest var1);

    @Fluent
    public ProxyRequest release();

    public HttpServerRequest outboundRequest();

    public ProxyResponse response();
}

