/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.emqx;

import cc.iotkit.comp.IMessageHandler;
import cc.iotkit.comp.emqx.EmqxConfig;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(AuthVerticle.class);
    private HttpServer backendServer;
    private IMessageHandler executor;
    private final EmqxConfig config;

    public void setExecutor(IMessageHandler executor) {
        this.executor = executor;
    }

    public AuthVerticle(EmqxConfig config) {
        this.config = config;
    }

    @Override
    public void start() {
        this.backendServer = this.vertx.createHttpServer();
        Router backendRouter = Router.router(this.vertx);
        backendRouter.route().handler(BodyHandler.create());
        backendRouter.route(HttpMethod.POST, "/mqtt/auth").handler(rc -> {
            String json = rc.getBodyAsString();
            log.info("mqtt auth:{}", (Object)json);
            try {
                HashMap<String, String> head = new HashMap<String, String>();
                head.put("topic", "/mqtt/auth");
                this.executor.onReceive(head, "auth", json);
                this.httpResult(rc.response(), 200);
            }
            catch (Throwable e) {
                this.httpResult(rc.response(), 500);
                log.error("mqtt auth failed", e);
            }
        });
        backendRouter.route(HttpMethod.POST, "/mqtt/acl").handler(rc -> {
            String json = rc.getBodyAsString();
            log.info("mqtt acl:{}", (Object)json);
            try {
                HashMap<String, String> head = new HashMap<String, String>();
                head.put("topic", "/mqtt/acl");
                this.executor.onReceive(head, "acl", json);
                this.httpResult(rc.response(), 200);
            }
            catch (Throwable e) {
                this.httpResult(rc.response(), 500);
                log.error("mqtt acl failed", e);
            }
        });
        this.backendServer.requestHandler(backendRouter).listen(this.config.getAuthPort());
    }

    private void httpResult(HttpServerResponse response, int code) {
        response.putHeader("Content-Type", "application/json");
        response.setStatusCode(code);
        response.end("{\"result\": \"" + (code == 200 ? "allow" : "deny") + "\"}");
    }

    @Override
    public void stop() throws Exception {
        this.backendServer.close(voidAsyncResult -> log.info("close emqx auth server..."));
    }
}

