/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.utils;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ContainerUtils {
    private static <E, R> String getMethodName(SerializableFunction<E, R> function) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        method.setAccessible(Boolean.TRUE);
        SerializedLambda serializedLambda = (SerializedLambda)method.invoke(function, new Object[0]);
        String implMethodName = serializedLambda.getImplMethodName();
        return implMethodName;
    }

    private static <E, R, T> Method getMethod(Class<T> clazz, SerializableFunction<E, R> function) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = ContainerUtils.getMethodName(function);
        return clazz.getMethod(methodName, new Class[0]);
    }

    private static <K, T> List<K> buildListByGetField(List<T> objList, Class<K> clazz, Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<K> keyList = new ArrayList<K>();
        for (T obj : objList) {
            Object keyObject = method.invoke(obj, new Object[0]);
            if (!clazz.isInstance(keyObject)) continue;
            K key = clazz.cast(keyObject);
            keyList.add(key);
        }
        return keyList;
    }

    public static <K, T> List<?> buildKeyList(List<T> objList, Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList keyList = new ArrayList();
        Class<?> returnType = method.getReturnType();
        for (T obj : objList) {
            Object keyObject = method.invoke(obj, new Object[0]);
            if (!returnType.isInstance(keyObject)) continue;
            keyList.add(returnType.cast(keyObject));
        }
        return keyList;
    }

    public static <E, R, K, T> List<K> buildListByGetField(List<T> objList, SerializableFunction<E, R> function, Class<K> clazz) {
        if (objList.isEmpty()) {
            return new ArrayList();
        }
        try {
            Method method = ContainerUtils.getMethod(objList.get(0).getClass(), function);
            return ContainerUtils.buildListByGetField(objList, clazz, method);
        }
        catch (NoSuchMethodException e) {
            return new ArrayList();
        }
        catch (SecurityException e) {
            return new ArrayList();
        }
        catch (IllegalAccessException e) {
            return new ArrayList();
        }
        catch (IllegalArgumentException e) {
            return new ArrayList();
        }
        catch (InvocationTargetException e) {
            return new ArrayList();
        }
    }

    public static <K, T> Map<K, T> buildMapByKeyAndFinalMethod(List<T> objList, Class<K> clazz, Method method) {
        try {
            HashMap<K, T> uid2deviceMap = new HashMap<K, T>();
            for (T obj : objList) {
                Object keyObject = method.invoke(obj, new Object[0]);
                if (!clazz.isInstance(keyObject)) continue;
                K key = clazz.cast(keyObject);
                uid2deviceMap.put(key, obj);
            }
            return uid2deviceMap;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static <E, R, K, T> Map<K, T> buildMapByKey(List<T> objList, SerializableFunction<E, R> function) {
        if (objList.isEmpty()) {
            return new HashMap();
        }
        try {
            Method method = ContainerUtils.getMethod(objList.get(0).getClass(), function);
            return ContainerUtils.buildMapByKey(objList, method);
        }
        catch (NoSuchMethodException e) {
            return new HashMap();
        }
        catch (SecurityException e) {
            return new HashMap();
        }
        catch (IllegalAccessException e) {
            return new HashMap();
        }
        catch (IllegalArgumentException e) {
            return new HashMap();
        }
        catch (InvocationTargetException e) {
            return new HashMap();
        }
    }

    public static <K, T> Map<K, T> buildMapByKey(List<T> objList, Method method) {
        try {
            HashMap<Object, T> uid2deviceMap = new HashMap<Object, T>();
            for (T obj : objList) {
                Object keyObject = method.invoke(obj, new Object[0]);
                uid2deviceMap.put(keyObject, obj);
            }
            return uid2deviceMap;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static <K, T> Map<K, List<T>> buildMapByTypeAndFinalMethod(List<T> objList, Class<K> clazz, Method method) {
        try {
            HashMap<K, ArrayList<T>> uid2deviceMap = new HashMap<K, ArrayList<T>>();
            for (T obj : objList) {
                Object keyObject = method.invoke(obj, new Object[0]);
                if (!clazz.isInstance(keyObject)) continue;
                K key = clazz.cast(keyObject);
                ArrayList<T> list = (ArrayList<T>)uid2deviceMap.get(key);
                if (list == null) {
                    list = new ArrayList<T>();
                    uid2deviceMap.put(key, list);
                }
                list.add(obj);
            }
            return uid2deviceMap;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static <E, R, K, T> Map<K, T> buildMapByKeyAndFinalMethod(List<T> objList, SerializableFunction<E, R> function, Class<K> clazz) {
        if (objList.isEmpty()) {
            return new HashMap();
        }
        try {
            Method method = ContainerUtils.getMethod(objList.get(0).getClass(), function);
            return ContainerUtils.buildMapByKeyAndFinalMethod(objList, clazz, method);
        }
        catch (NoSuchMethodException e) {
            return new HashMap();
        }
        catch (SecurityException e) {
            return new HashMap();
        }
        catch (IllegalAccessException e) {
            return new HashMap();
        }
        catch (IllegalArgumentException e) {
            return new HashMap();
        }
        catch (InvocationTargetException e) {
            return new HashMap();
        }
    }

    public static <E, R, K, T> Map<K, List<T>> buildMapByTypeAndFinalMethod(List<T> objList, SerializableFunction<E, R> function, Class<K> clazz) {
        if (objList.isEmpty()) {
            return new HashMap();
        }
        try {
            Method method = ContainerUtils.getMethod(objList.get(0).getClass(), function);
            return ContainerUtils.buildMapByTypeAndFinalMethod(objList, clazz, method);
        }
        catch (NoSuchMethodException e) {
            return new HashMap();
        }
        catch (SecurityException e) {
            return new HashMap();
        }
        catch (IllegalAccessException e) {
            return new HashMap();
        }
        catch (IllegalArgumentException e) {
            return new HashMap();
        }
        catch (InvocationTargetException e) {
            return new HashMap();
        }
    }

    public static <K, T> Map<K, Map<String, Object>> buildMapByMapAt(List<Map<String, Object>> objList, String mapKey, Class<K> clazz) {
        if (objList.isEmpty()) {
            return new HashMap();
        }
        HashMap<Object, Map<String, Object>> result = new HashMap<Object, Map<String, Object>>();
        for (Map<String, Object> obj : objList) {
            Object value = obj.get(mapKey);
            if (!clazz.isInstance(value)) continue;
            result.put(value, obj);
        }
        return result;
    }

    public static <E, R, K, T> T getObjectByKey(List<T> objList, SerializableFunction<E, R> function, K key) {
        try {
            if (objList.isEmpty()) {
                return null;
            }
            Method method = ContainerUtils.getMethod(objList.get(0).getClass(), function);
            for (T obj : objList) {
                Object keyObject = method.invoke(obj, new Object[0]);
                if (!key.getClass().isInstance(keyObject) || !keyObject.equals(key)) continue;
                return obj;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static <K, V> Map<V, K> exchange(Map<K, V> key2value) {
        HashMap<V, K> result = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : key2value.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> Map<V, List<K>> exchanges(Map<K, V> key2value) {
        HashMap<V, ArrayList<K>> result = new HashMap<V, ArrayList<K>>();
        for (Map.Entry<K, V> entry : key2value.entrySet()) {
            ArrayList<K> list = (ArrayList<K>)result.get(entry.getValue());
            if (list == null) {
                list = new ArrayList<K>();
                result.put(entry.getValue(), list);
            }
            list.add(entry.getKey());
        }
        return result;
    }

    public static <K, V> List<V> buildValueListByKey(Map<K, V> key2value, Collection<K> keyList) {
        ArrayList<V> resultList = new ArrayList<V>();
        for (K key : keyList) {
            V value = key2value.get(key);
            if (value == null) continue;
            resultList.add(value);
        }
        return resultList;
    }

    public static <A, B> List<B> buildClassList(List<A> aClazzList, Class<B> bClazz) {
        ArrayList<B> bInstanceList = new ArrayList<B>();
        for (A aInstance : aClazzList) {
            if (!bClazz.isInstance(aInstance)) continue;
            bInstanceList.add(bClazz.cast(aInstance));
        }
        return bInstanceList;
    }

    @FunctionalInterface
    public static interface SerializableFunction<E, R>
    extends Function<E, R>,
    Serializable {
    }
}

