/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core.util;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Signature {
    private static final String CHARSET = "utf-8";

    public static String sign(String secret, Map<String, String> header, Map<String, String> data) throws Exception {
        return Signature.sign(secret, header, data, null);
    }

    public static String sign(String secret, Map<String, String> header, Map<String, String> param, byte[] body) throws Exception {
        LinkedHashMap<String, List<String>> ps = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, String> e : param.entrySet()) {
            ArrayList<String> ls = new ArrayList<String>();
            ps.put(e.getKey(), ls);
            ls.add(e.getValue());
        }
        return Signature.sign(secret, header.get("application"), header.get("timestamp"), ps, body);
    }

    public static String sign(String secret, String application, String timestamp, Map<String, List<String>> param, byte[] body) throws Exception {
        if (secret == null) {
            throw new Exception("Secret cannot be null");
        }
        if (application == null) {
            throw new Exception("Application cannot be null");
        }
        if (timestamp == null) {
            throw new Exception("Timestamp cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("application").append(":").append(application).append("\n");
        sb.append("timestamp").append(":").append(timestamp).append("\n");
        if (param != null) {
            TreeSet<String> keys = new TreeSet<String>(param.keySet());
            for (String s : keys) {
                List<String> ls = param.get(s);
                if (ls == null || ls.isEmpty()) {
                    sb.append(s).append(":").append("").append("\n");
                    continue;
                }
                for (String val : ls) {
                    sb.append(s).append(":").append(val == null ? "" : val).append("\n");
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(sb.toString().getBytes(CHARSET));
        if (body != null && body.length > 0) {
            baos.write(body);
            baos.write("\n".getBytes(CHARSET));
        }
        return new String(Base64.encodeBase64((byte[])Signature.encryptHMAC(secret, baos.toByteArray())));
    }

    public static byte[] encryptHMAC(String secret, byte[] data) {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CHARSET), "HmacSha1");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return bytes;
    }
}

