/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.biz;

import cc.iotkit.common.utils.JsonUtils;
import cc.iotkit.comp.CompConfig;
import cc.iotkit.comp.IComponent;
import cc.iotkit.comp.biz.HttpConfig;
import cc.iotkit.comp.biz.HttpContent;
import cc.iotkit.script.IScriptEngine;
import cc.iotkit.script.ScriptEngineFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBizComponent
implements IComponent {
    private static final Logger log = LoggerFactory.getLogger(HttpBizComponent.class);
    private final Vertx vertx = Vertx.vertx();
    private final IScriptEngine scriptEngine = ScriptEngineFactory.getScriptEngine((String)"js");
    private Object scriptObj;
    private CompConfig config;
    private HttpConfig httpConfig;
    private String script;
    private HttpServer backendServer;
    private String id;

    public void create(CompConfig config) {
        this.id = UUID.randomUUID().toString();
        this.httpConfig = (HttpConfig)JsonUtils.parseObject((String)config.getOther(), HttpConfig.class);
        this.scriptEngine.setScript(this.script);
    }

    public void start() {
        this.backendServer = this.vertx.createHttpServer();
        Router backendRouter = Router.router(this.vertx);
        backendRouter.route().handler(BodyHandler.create()).handler(rc -> {
            block5: {
                try {
                    Map<String, Object> httpHeader = HttpBizComponent.getData(rc.request().headers());
                    log.info("request header:{}", (Object)JsonUtils.toJsonString(httpHeader));
                    Map<String, List<Object>> httpParams = HttpBizComponent.getListData(rc.request().params());
                    log.info("request params:{}", (Object)JsonUtils.toJsonString(httpParams));
                    HttpServerRequest httpRequest = rc.request();
                    String contentType = httpRequest.headers().get("Content-Type");
                    Map<String, Object> responseHeader = new HashMap<String, Object>();
                    if ("application/json".equals(contentType)) {
                        String response;
                        String bodyStr = rc.getBody().toString();
                        Map body = (Map)JsonUtils.parseObject((String)bodyStr, Map.class);
                        log.info("request body:{}", (Object)bodyStr);
                        try {
                            HttpContent content = (HttpContent)this.scriptEngine.invokeMethod((TypeReference)new TypeReference<HttpContent>(){}, "onReceive", new Object[]{httpRequest.method().name(), httpRequest.path(), httpHeader, httpParams, body});
                            responseHeader = content.getHeader();
                            response = content.getContent();
                            response = response == null ? "" : response;
                        }
                        catch (Throwable e) {
                            log.error("invokeMethod onReceive error", e);
                            response = e.getMessage();
                        }
                        HttpServerResponse httpServerResponse = rc.response();
                        responseHeader.forEach((key, value) -> {
                            key = key.replaceAll("([A-Z])", "-$1").toLowerCase();
                            httpServerResponse.putHeader((String)key, value.toString());
                        });
                        log.info("response,header:{},content:{}", responseHeader, (Object)response);
                        httpServerResponse.end(response);
                        break block5;
                    }
                    rc.response().end("");
                }
                catch (Throwable e) {
                    log.error("handle request error", e);
                    rc.response().end("server error:" + e.getMessage());
                }
            }
        });
        this.backendServer.requestHandler(backendRouter).listen(this.httpConfig.getPort(), http -> {
            if (http.succeeded()) {
                log.info("http server create succeed,port:{}", (Object)this.httpConfig.getPort());
            } else {
                log.error("http server create failed", http.cause());
            }
        });
    }

    public void putScriptEnv(String key, Object value) {
        this.scriptEngine.putScriptEnv(key, value);
    }

    public void stop() {
        this.backendServer.close();
    }

    public void destroy() {
    }

    private static Map<String, List<Object>> getListData(MultiMap multiMap) {
        HashMap<String, List<Object>> listData = new HashMap<String, List<Object>>();
        for (Map.Entry<String, String> entry : multiMap.entries()) {
            String key = entry.getKey();
            String value = entry.getValue();
            listData.putIfAbsent(key, new ArrayList());
            ((List)listData.get(key)).add(value);
        }
        return listData;
    }

    private static Map<String, Object> getData(MultiMap multiMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : multiMap.entries()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return data;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public IScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public Object getScriptObj() {
        return this.scriptObj;
    }

    public CompConfig getConfig() {
        return this.config;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public String getScript() {
        return this.script;
    }

    public HttpServer getBackendServer() {
        return this.backendServer;
    }

    public String getId() {
        return this.id;
    }

    public void setScriptObj(Object scriptObj) {
        this.scriptObj = scriptObj;
    }

    public void setConfig(CompConfig config) {
        this.config = config;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setBackendServer(HttpServer backendServer) {
        this.backendServer = backendServer;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpBizComponent)) {
            return false;
        }
        HttpBizComponent other = (HttpBizComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vertx this$vertx = this.getVertx();
        Vertx other$vertx = other.getVertx();
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        IScriptEngine this$scriptEngine = this.getScriptEngine();
        IScriptEngine other$scriptEngine = other.getScriptEngine();
        if (this$scriptEngine == null ? other$scriptEngine != null : !this$scriptEngine.equals(other$scriptEngine)) {
            return false;
        }
        Object this$scriptObj = this.getScriptObj();
        Object other$scriptObj = other.getScriptObj();
        if (this$scriptObj == null ? other$scriptObj != null : !this$scriptObj.equals(other$scriptObj)) {
            return false;
        }
        CompConfig this$config = this.getConfig();
        CompConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        HttpConfig this$httpConfig = this.getHttpConfig();
        HttpConfig other$httpConfig = other.getHttpConfig();
        if (this$httpConfig == null ? other$httpConfig != null : !((Object)this$httpConfig).equals(other$httpConfig)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        HttpServer this$backendServer = this.getBackendServer();
        HttpServer other$backendServer = other.getBackendServer();
        if (this$backendServer == null ? other$backendServer != null : !this$backendServer.equals(other$backendServer)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpBizComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertx $vertx = this.getVertx();
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        IScriptEngine $scriptEngine = this.getScriptEngine();
        result = result * 59 + ($scriptEngine == null ? 43 : $scriptEngine.hashCode());
        Object $scriptObj = this.getScriptObj();
        result = result * 59 + ($scriptObj == null ? 43 : $scriptObj.hashCode());
        CompConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        HttpConfig $httpConfig = this.getHttpConfig();
        result = result * 59 + ($httpConfig == null ? 43 : ((Object)$httpConfig).hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        HttpServer $backendServer = this.getBackendServer();
        result = result * 59 + ($backendServer == null ? 43 : $backendServer.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "HttpBizComponent(vertx=" + this.getVertx() + ", scriptEngine=" + this.getScriptEngine() + ", scriptObj=" + this.getScriptObj() + ", config=" + this.getConfig() + ", httpConfig=" + this.getHttpConfig() + ", script=" + this.getScript() + ", backendServer=" + this.getBackendServer() + ", id=" + this.getId() + ")";
    }
}

