/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core.http;

import com.ctg.ag.sdk.core.HttpClient;
import com.ctg.ag.sdk.core.exception.SdkClientException;
import com.ctg.ag.sdk.core.model.BuilderParams;
import java.lang.reflect.Constructor;

public class HttpClientFactory {
    public static String HTTP_CLIENT_IMPL_KEY = "Telecom API Gateway Java SDK SDK Httpclient";
    public static String DEFAULT_HTTP_CLIENT = "com.ctg.ag.sdk.core.http.ApacheHttpClient";

    public static HttpClient buildClient(BuilderParams builderParams) {
        try {
            Class<?> httpClientClass;
            String httpClientClassName = System.getProperty(HTTP_CLIENT_IMPL_KEY);
            if (httpClientClassName == null || httpClientClassName.isEmpty()) {
                httpClientClassName = DEFAULT_HTTP_CLIENT;
            }
            if (!HttpClient.class.isAssignableFrom(httpClientClass = Class.forName(httpClientClassName))) {
                throw new IllegalStateException(String.format("%s is not assignable from HttpClient", httpClientClassName));
            }
            Constructor<?> constructor = httpClientClass.getConstructor(BuilderParams.class);
            return (HttpClient)constructor.newInstance(builderParams);
        }
        catch (Exception e) {
            throw new SdkClientException("HttpClientFactory buildClient failed", e);
        }
    }
}

