/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.analysis;

import cc.iotkit.common.thing.ThingService;
import cc.iotkit.common.utils.JsonUtil;
import cc.iotkit.common.utils.UniqueIdUtil;
import cc.iotkit.comp.DLT645.analysis.DLT645Analysis;
import cc.iotkit.comp.DLT645.analysis.DLT645Data;
import cc.iotkit.comp.DLT645.analysis.DLT645FunCode;
import cc.iotkit.comp.DLT645.utils.ByteUtils;
import cc.iotkit.converter.Device;
import cc.iotkit.converter.DeviceMessage;
import cc.iotkit.converter.IConverter;
import cc.iotkit.model.device.message.ThingModelMessage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLT645Converter
implements IConverter {
    private static final Logger log = LoggerFactory.getLogger(DLT645Converter.class);

    public void setScript(String script) {
    }

    public ThingModelMessage decode(DeviceMessage msg) {
        ThingModelMessage tmm = null;
        ReportData rd = (ReportData)JsonUtil.parse((String)JsonUtil.toJsonString((Object)msg.getContent()), ReportData.class);
        if ("property".equals(rd.type) && "report".equals(rd.getIdentifier())) {
            tmm = ThingModelMessage.builder().mid(msg.getMid()).productKey(msg.getProductKey()).deviceName(msg.getDeviceName()).identifier(rd.getIdentifier()).occurred(rd.getOccur()).time(rd.getTime()).type(rd.getType()).data(rd.getData()).build();
        }
        return tmm;
    }

    public DeviceMessage encode(ThingService<?> service, Device device) {
        DeviceMessage deviceMsg = new DeviceMessage();
        deviceMsg.setProductKey(service.getProductKey());
        deviceMsg.setDeviceName(service.getDeviceName());
        deviceMsg.setMid(UniqueIdUtil.newRequestId());
        Map sd = (Map)service.getParams();
        String funCode = "";
        if ("service".equals(service.getType())) {
            if ("readData".equals(service.getIdentifier())) {
                funCode = "\u8bfb\u6570\u636e";
            } else if ("writeData".equals(service.getIdentifier())) {
                funCode = "\u5199\u6570\u636e";
            }
        }
        deviceMsg.setContent((Object)this.packData((String)sd.get("deviceAddr"), funCode, (String)sd.get("dataIdentifier")));
        return deviceMsg;
    }

    public void putScriptEnv(String key, Object value) {
    }

    private String packData(String deviceAddress, String funCode, String dataIdentifier) {
        byte[] tmp = ByteUtils.hexStringToByteArray(deviceAddress);
        byte[] adrr = new byte[6];
        ByteUtils.byteInvertedOrder(tmp, adrr);
        DLT645Data dataEntity = DLT645Analysis.inst().getTemplateByDIn().get(dataIdentifier);
        if (dataEntity == null) {
            throw new RuntimeException("CSV\u6a21\u677f\u6587\u4ef6\u4e2d\u672a\u5b9a\u4e49\u5bf9\u8c61:" + dataIdentifier + " \uff0c\u4f60\u9700\u8981\u5728\u6a21\u677f\u4e2d\u6dfb\u52a0\u8be5\u5bf9\u8c61\u4fe1\u606f");
        }
        byte byFun = Byte.decode(String.valueOf(DLT645FunCode.getCodev1997(funCode)));
        byte[] pack = DLT645Analysis.packCmd(adrr, byFun, dataEntity.getDIn());
        return ByteUtils.byteArrayToHexString(pack, false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DLT645Converter)) {
            return false;
        }
        DLT645Converter other = (DLT645Converter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DLT645Converter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "DLT645Converter()";
    }

    public static class ReportData {
        private String type;
        private String identifier;
        private Long occur;
        private Long time;
        private Object data;

        public String getType() {
            return this.type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Long getOccur() {
            return this.occur;
        }

        public Long getTime() {
            return this.time;
        }

        public Object getData() {
            return this.data;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setOccur(Long occur) {
            this.occur = occur;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportData)) {
                return false;
            }
            ReportData other = (ReportData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$occur = this.getOccur();
            Long other$occur = other.getOccur();
            if (this$occur == null ? other$occur != null : !((Object)this$occur).equals(other$occur)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReportData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $occur = this.getOccur();
            result = result * 59 + ($occur == null ? 43 : ((Object)$occur).hashCode());
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "DLT645Converter.ReportData(type=" + this.getType() + ", identifier=" + this.getIdentifier() + ", occur=" + this.getOccur() + ", time=" + this.getTime() + ", data=" + this.getData() + ")";
        }
    }
}

