/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.emqx;

import cc.iotkit.common.exception.BizException;
import cc.iotkit.common.thing.ThingService;
import cc.iotkit.common.utils.JsonUtil;
import cc.iotkit.comp.AbstractDeviceComponent;
import cc.iotkit.comp.CompConfig;
import cc.iotkit.comp.IMessageHandler;
import cc.iotkit.comp.emqx.AuthVerticle;
import cc.iotkit.comp.emqx.EmqxConfig;
import cc.iotkit.comp.emqx.TransparentConverter;
import cc.iotkit.comp.emqx.TransparentMsg;
import cc.iotkit.comp.model.DeviceState;
import cc.iotkit.comp.utils.SpringUtils;
import cc.iotkit.converter.DeviceMessage;
import cc.iotkit.data.IDeviceInfoData;
import cc.iotkit.model.Id;
import cc.iotkit.model.device.DeviceInfo;
import cc.iotkit.model.device.message.ThingModelMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmqxDeviceComponent
extends AbstractDeviceComponent {
    private static final Logger log = LoggerFactory.getLogger(EmqxDeviceComponent.class);
    private Vertx vertx;
    private AuthVerticle authVerticle;
    private CountDownLatch countDownLatch;
    private String deployedId;
    private EmqxConfig mqttConfig;
    private MqttClient client;
    private final Set<String> compMqttClientIdList = new HashSet<String>();
    private final TransparentConverter transparentConverter = new TransparentConverter();

    public void create(CompConfig config) {
        super.create(config);
        this.vertx = Vertx.vertx();
        this.mqttConfig = (EmqxConfig)JsonUtil.parse((String)config.getOther(), EmqxConfig.class);
        this.authVerticle = new AuthVerticle(this.mqttConfig);
    }

    public void start() {
        try {
            this.compMqttClientIdList.add(this.mqttConfig.getClientId());
            this.authVerticle.setExecutor(this.getHandler());
            this.countDownLatch = new CountDownLatch(1);
            Future<String> future = this.vertx.deployVerticle(this.authVerticle);
            future.onSuccess(s -> {
                this.deployedId = s;
                this.countDownLatch.countDown();
                log.error("start emqx auth component success");
            });
            future.onFailure(e -> {
                this.countDownLatch.countDown();
                log.error("start emqx auth component failed", e);
            });
            this.countDownLatch.await();
            MqttClientOptions options = new MqttClientOptions().setClientId(this.mqttConfig.getClientId()).setUsername(this.mqttConfig.getUsername()).setPassword(this.mqttConfig.getPassword()).setCleanSession(true).setKeepAliveInterval(60);
            if (this.mqttConfig.isSsl()) {
                options.setSsl(true).setTrustAll(true);
            }
            this.client = MqttClient.create(this.vertx, options);
            List<String> topics = this.mqttConfig.getSubscribeTopics();
            HashMap<String, Integer> subscribes = new HashMap<String, Integer>();
            for (String topic : topics) {
                subscribes.put(topic, 1);
            }
            this.client.publishHandler(p -> {
                log.info("Client received message on [{}] payload [{}] with QoS [{}]", new Object[]{p.topicName(), p.payload().toString(Charset.defaultCharset()), p.qosLevel()});
                String topic = p.topicName();
                String payload = p.payload().toString();
                try {
                    IMessageHandler messageHandler = this.getHandler();
                    if (messageHandler != null) {
                        HashMap<String, String> head = new HashMap<String, String>();
                        head.put("topic", topic);
                        messageHandler.onReceive(head, "", payload);
                    }
                }
                catch (Exception e) {
                    log.error("message is illegal.", (Throwable)e);
                }
            });
            this.client.connect(this.mqttConfig.getPort(), this.mqttConfig.getBroker(), s -> {
                if (s.succeeded()) {
                    log.info("client connect success.");
                    this.client.subscribe(subscribes, e -> {
                        if (e.succeeded()) {
                            log.info("===>subscribe success: {}", e.result());
                        } else {
                            log.error("===>subscribe fail: ", e.cause());
                        }
                    });
                } else {
                    log.error("client connect fail: ", s.cause());
                }
            }).exceptionHandler(event -> log.error("client fail: ", event.getCause()));
        }
        catch (Throwable e2) {
            throw new BizException("start emqx auth component error", e2);
        }
    }

    public void stop() {
        this.authVerticle.stop();
        Future<Void> future = this.vertx.undeploy(this.deployedId);
        future.onSuccess(unused -> log.info("stop emqx auth component success"));
        this.client.disconnect().onSuccess(unused -> log.info("stop emqx component success")).onFailure(unused -> log.info("stop emqx component failure"));
    }

    public void destroy() {
    }

    public void onDeviceStateChange(DeviceState state) {
        DeviceState.Parent parent = state.getParent();
        if (parent == null) {
            return;
        }
        IDeviceInfoData deviceInfoService = (IDeviceInfoData)SpringUtils.getBean((String)"deviceInfoDataCache");
        DeviceInfo deviceInfo = deviceInfoService.findByProductKeyAndDeviceName(state.getProductKey(), state.getDeviceName());
        if (deviceInfo != null) {
            boolean isOnline = "online".equals(state.getState());
            deviceInfo.getState().setOnline(isOnline);
            if (!isOnline) {
                deviceInfo.getState().setOfflineTime(Long.valueOf(System.currentTimeMillis()));
            }
            if (isOnline) {
                deviceInfo.getState().setOnlineTime(Long.valueOf(System.currentTimeMillis()));
            }
            deviceInfoService.save((Id)deviceInfo);
        }
    }

    public DeviceMessage send(DeviceMessage message) {
        Object obj = message.getContent();
        if (!(obj instanceof Map)) {
            throw new BizException("message content is not Map");
        }
        Message msg = new Message();
        try {
            BeanUtils.populate((Object)msg, (Map)((Map)obj));
        }
        catch (Throwable e) {
            throw new BizException("message content is incorrect");
        }
        log.info("publish topic:{},payload:{}", (Object)msg.getTopic(), (Object)msg.getPayload());
        this.client.publish(msg.getTopic(), Buffer.buffer(msg.getPayload()), MqttQoS.AT_LEAST_ONCE, false, false);
        return message;
    }

    public ThingModelMessage transparentDecode(Map<String, Object> msg) throws InvocationTargetException, IllegalAccessException {
        TransparentMsg transparentMsg = new TransparentMsg();
        BeanUtils.populate((Object)transparentMsg, msg);
        return this.transparentConverter.decode(transparentMsg);
    }

    public DeviceMessage transparentEncode(ThingService<?> service, cc.iotkit.converter.Device device) {
        return this.transparentConverter.encode(service, device);
    }

    public Object getCompMqttClientIdList() {
        String[] result = this.compMqttClientIdList.toArray(new String[0]);
        return JsonUtil.toJsonString((Object)result);
    }

    public static class Device {
        private String productKey;
        private String deviceName;

        public String getProductKey() {
            return this.productKey;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setProductKey(String productKey) {
            this.productKey = productKey;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Device)) {
                return false;
            }
            Device other = (Device)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$productKey = this.getProductKey();
            String other$productKey = other.getProductKey();
            if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
                return false;
            }
            String this$deviceName = this.getDeviceName();
            String other$deviceName = other.getDeviceName();
            return !(this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Device;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $productKey = this.getProductKey();
            result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
            String $deviceName = this.getDeviceName();
            result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
            return result;
        }

        public Device() {
        }

        public Device(String productKey, String deviceName) {
            this.productKey = productKey;
            this.deviceName = deviceName;
        }

        public String toString() {
            return "EmqxDeviceComponent.Device(productKey=" + this.getProductKey() + ", deviceName=" + this.getDeviceName() + ")";
        }
    }

    public static class Message {
        private String topic;
        private String payload;

        public String getTopic() {
            return this.topic;
        }

        public String getPayload() {
            return this.payload;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "EmqxDeviceComponent.Message(topic=" + this.getTopic() + ", payload=" + this.getPayload() + ")";
        }
    }
}

