/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.BridgeEvent;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BridgeEventImpl;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventBusBridgeImpl
implements Handler<SockJSSocket> {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusBridgeImpl.class);
    private final Map<SockJSSocket, SockInfo> sockInfos = new HashMap<SockJSSocket, SockInfo>();
    private final List<PermittedOptions> inboundPermitted;
    private final List<PermittedOptions> outboundPermitted;
    private final int maxAddressLength;
    private final int maxHandlersPerSocket;
    private final long pingTimeout;
    private final long replyTimeout;
    private final Vertx vertx;
    private final EventBus eb;
    private final Map<String, Message<?>> messagesAwaitingReply = new HashMap();
    private final Map<String, Pattern> compiledREs = new HashMap<String, Pattern>();
    private final Handler<BridgeEvent> bridgeEventHandler;
    private final AuthorizationProvider authzProvider;

    public EventBusBridgeImpl(Vertx vertx, AuthorizationProvider authzProvider, SockJSBridgeOptions options, Handler<BridgeEvent> bridgeEventHandler) {
        this.vertx = vertx;
        this.eb = vertx.eventBus();
        this.authzProvider = authzProvider;
        this.inboundPermitted = options.getInboundPermitteds() == null ? new ArrayList() : options.getInboundPermitteds();
        this.outboundPermitted = options.getOutboundPermitteds() == null ? new ArrayList() : options.getOutboundPermitteds();
        this.maxAddressLength = options.getMaxAddressLength();
        this.maxHandlersPerSocket = options.getMaxHandlersPerSocket();
        this.pingTimeout = options.getPingTimeout();
        this.replyTimeout = options.getReplyTimeout();
        this.bridgeEventHandler = bridgeEventHandler;
    }

    private void handleSocketData(SockJSSocket sock, Buffer data, Map<String, MessageConsumer<?>> registrations) {
        JsonObject msg;
        try {
            msg = new JsonObject(data.toString());
        }
        catch (DecodeException e) {
            EventBusBridgeImpl.replyError(sock, "invalid_json");
            return;
        }
        String type = msg.getString("type");
        if (type == null) {
            EventBusBridgeImpl.replyError(sock, "missing_type");
            return;
        }
        if (type.equals("ping")) {
            this.internalHandlePing(sock);
        } else {
            String address = msg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            switch (type) {
                case "send": {
                    this.internalHandleSendOrPub(sock, true, msg);
                    break;
                }
                case "publish": {
                    this.internalHandleSendOrPub(sock, false, msg);
                    break;
                }
                case "register": {
                    this.internalHandleRegister(sock, msg, registrations);
                    break;
                }
                case "unregister": {
                    this.internalHandleUnregister(sock, msg, registrations);
                    break;
                }
                default: {
                    LOG.error("Invalid type in incoming message: " + type);
                    EventBusBridgeImpl.replyError(sock, "invalid_type");
                }
            }
        }
    }

    private void checkCallHook(Supplier<BridgeEventImpl> eventSupplier) {
        this.checkCallHook(eventSupplier, null, null);
    }

    private void checkCallHook(Supplier<BridgeEventImpl> eventSupplier, Runnable okAction, Runnable rejectAction) {
        if (this.bridgeEventHandler == null) {
            if (okAction != null) {
                okAction.run();
            }
        } else {
            BridgeEventImpl event = eventSupplier.get();
            boolean before = this.sockInfos.containsKey(event.socket());
            this.bridgeEventHandler.handle(event);
            event.future().onFailure(err -> LOG.error("Failure in bridge event handler", (Throwable)err)).onSuccess(ok -> {
                if (ok.booleanValue()) {
                    boolean after = this.sockInfos.containsKey(event.socket());
                    if (before != after) {
                        if (rejectAction != null) {
                            rejectAction.run();
                        } else {
                            LOG.debug("SockJSSocket state change prevented send or pub");
                        }
                    } else if (okAction != null) {
                        okAction.run();
                    }
                } else if (rejectAction != null) {
                    rejectAction.run();
                } else {
                    LOG.debug("Bridge handler prevented send or pub");
                }
            });
        }
    }

    private void internalHandleSendOrPub(SockJSSocket sock, boolean send, JsonObject msg) {
        this.checkCallHook(() -> new BridgeEventImpl(send ? BridgeEventType.SEND : BridgeEventType.PUBLISH, msg, sock), () -> {
            String address = msg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            this.doSendOrPub(send, sock, address, msg);
        }, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
    }

    private boolean checkMaxHandlers(SockJSSocket sock, SockInfo info) {
        if (info.handlerCount < this.maxHandlersPerSocket) {
            return true;
        }
        LOG.warn("Refusing to register as max_handlers_per_socket reached already");
        EventBusBridgeImpl.replyError(sock, "max_handlers_reached");
        return false;
    }

    private void internalHandleRegister(SockJSSocket sock, JsonObject rawMsg, Map<String, MessageConsumer<?>> registrations) {
        SockInfo info = this.sockInfos.get(sock);
        if (!this.checkMaxHandlers(sock, info)) {
            return;
        }
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.REGISTER, rawMsg, sock), () -> {
            boolean debug = LOG.isDebugEnabled();
            String address = rawMsg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            if (address.length() > this.maxAddressLength) {
                LOG.warn("Refusing to register as address length > max_address_length");
                EventBusBridgeImpl.replyError(sock, "max_address_length_reached");
                return;
            }
            Match match = this.checkMatches(false, address, null);
            if (match.doesMatch) {
                if (registrations.containsKey(address)) {
                    LOG.warn("Refusing to register as address is already registered");
                    EventBusBridgeImpl.replyError(sock, "address_already_registered");
                    return;
                }
                Handler<Message> handler = msg -> {
                    Match curMatch = this.checkMatches(false, address, msg.body());
                    if (curMatch.doesMatch) {
                        if (curMatch.requiredAuthority != null) {
                            this.authorise(curMatch, sock.webUser(), res -> {
                                if (res.succeeded()) {
                                    if (((Boolean)res.result()).booleanValue()) {
                                        this.checkAddAccceptedReplyAddress((Message<?>)msg);
                                        this.deliverMessage(sock, address, (Message<?>)msg);
                                    } else if (debug) {
                                        LOG.debug("Outbound message for address " + address + " rejected because auth is required and socket is not authed");
                                    }
                                } else {
                                    LOG.error(res.cause());
                                }
                            });
                        } else {
                            this.checkAddAccceptedReplyAddress((Message<?>)msg);
                            this.deliverMessage(sock, address, (Message<?>)msg);
                        }
                    } else if (debug) {
                        LOG.debug("Outbound message for address " + address + " rejected because there is no inbound match");
                    }
                };
                ReadStream reg = this.eb.consumer(address).handler(handler);
                registrations.put(address, (MessageConsumer<?>)reg);
                ++info.handlerCount;
                this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.REGISTERED, rawMsg, sock));
            } else {
                if (debug) {
                    LOG.debug("Cannot register handler for address " + address + " because there is no inbound match");
                }
                EventBusBridgeImpl.replyError(sock, "access_denied");
            }
        }, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
    }

    private void internalHandleUnregister(SockJSSocket sock, JsonObject rawMsg, Map<String, MessageConsumer<?>> registrations) {
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.UNREGISTER, rawMsg, sock), () -> {
            String address = rawMsg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            Match match = this.checkMatches(false, address, null);
            if (match.doesMatch) {
                MessageConsumer registration = (MessageConsumer)registrations.remove(address);
                if (registration != null) {
                    SockInfo info = this.sockInfos.get(sock);
                    registration.unregister();
                    --info.handlerCount;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot unregister handler for address " + address + " because there is no inbound match");
                }
                EventBusBridgeImpl.replyError(sock, "access_denied");
            }
        }, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
    }

    private void internalHandlePing(SockJSSocket sock) {
        SockInfo info;
        Session webSession = sock.webSession();
        if (webSession != null) {
            webSession.setAccessed();
        }
        if ((info = this.sockInfos.get(sock)) != null) {
            info.pingInfo.lastPing = System.currentTimeMillis();
            this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_PING, null, sock));
        }
    }

    @Override
    public void handle(SockJSSocket sock) {
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_CREATED, null, sock), () -> {
            HashMap registrations = new HashMap();
            sock.handler(data -> this.handleSocketData(sock, (Buffer)data, registrations)).exceptionHandler(err -> this.handleSocketException(sock, (Throwable)err, registrations)).closeHandler(v -> this.handleSocketClosed(sock, registrations));
            PingInfo pingInfo = new PingInfo();
            pingInfo.timerID = this.vertx.setPeriodic(this.pingTimeout, id -> {
                if (System.currentTimeMillis() - pingInfo.lastPing >= this.pingTimeout) {
                    this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_IDLE, null, sock), ((SockJSSocketBase)sock)::closeAfterSessionExpired, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
                }
            });
            SockInfo sockInfo = new SockInfo();
            sockInfo.pingInfo = pingInfo;
            this.sockInfos.put(sock, sockInfo);
        }, sock::close);
    }

    private void handleSocketClosed(SockJSSocket sock, Map<String, MessageConsumer<?>> registrations) {
        this.clearSocketState(sock, registrations);
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_CLOSED, null, sock));
    }

    private void handleSocketException(SockJSSocket sock, Throwable err, Map<String, MessageConsumer<?>> registrations) {
        LOG.error("SockJSSocket exception", err);
        this.clearSocketState(sock, registrations);
        JsonObject msg = new JsonObject().put("type", "err").put("failureType", "socketException");
        if (err != null) {
            msg.put("message", err.getMessage());
        }
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_ERROR, msg, sock));
    }

    private void clearSocketState(SockJSSocket sock, Map<String, MessageConsumer<?>> registrations) {
        PingInfo pingInfo;
        for (MessageConsumer<?> registration : registrations.values()) {
            registration.unregister();
            this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.UNREGISTER, new JsonObject().put("type", "unregister").put("address", registration.address()), sock));
        }
        SockInfo info = this.sockInfos.remove(sock);
        if (info != null && (pingInfo = info.pingInfo) != null) {
            this.vertx.cancelTimer(pingInfo.timerID);
        }
    }

    private void checkAddAccceptedReplyAddress(Message<?> message) {
        String replyAddress = message.replyAddress();
        if (replyAddress != null) {
            this.messagesAwaitingReply.put(replyAddress, message);
            this.vertx.setTimer(this.replyTimeout, tid -> this.messagesAwaitingReply.remove(replyAddress));
        }
    }

    private void deliverMessage(SockJSSocket sock, String address, Message<?> message) {
        JsonObject envelope = new JsonObject().put("type", "rec").put("address", address).put("body", message.body());
        if (message.replyAddress() != null) {
            envelope.put("replyAddress", message.replyAddress());
        }
        if (message.headers() != null && !message.headers().isEmpty()) {
            JsonObject headersCopy = new JsonObject();
            for (String name : message.headers().names()) {
                List<String> values = message.headers().getAll(name);
                if (values.size() == 1) {
                    headersCopy.put(name, values.get(0));
                    continue;
                }
                headersCopy.put(name, values);
            }
            envelope.put("headers", headersCopy);
        }
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.RECEIVE, envelope, sock), () -> sock.write(Buffer.buffer(envelope.encode())), () -> LOG.debug("outbound message rejected by bridge event handler"));
    }

    private void doSendOrPub(boolean send, SockJSSocket sock, String address, JsonObject message) {
        Message<?> awaitingReply;
        Object body = message.getValue("body");
        JsonObject headers = message.getJsonObject("headers");
        String replyAddress = message.getString("replyAddress");
        if (replyAddress != null && replyAddress.length() > 36) {
            LOG.error("Will not send message, reply address is > 36 chars");
            EventBusBridgeImpl.replyError(sock, "invalid_reply_address");
            return;
        }
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug("Received msg from client in bridge. address:" + address + " message:" + body);
        }
        Match curMatch = (awaitingReply = this.messagesAwaitingReply.remove(address)) != null ? new Match(true) : this.checkMatches(true, address, body);
        if (curMatch.doesMatch) {
            if (curMatch.requiredAuthority != null) {
                User webUser = sock.webUser();
                if (webUser != null) {
                    this.authorise(curMatch, webUser, res -> {
                        if (res.succeeded()) {
                            if (((Boolean)res.result()).booleanValue()) {
                                this.checkAndSend(send, address, body, headers, sock, replyAddress, awaitingReply);
                            } else {
                                EventBusBridgeImpl.replyError(sock, "access_denied");
                                if (debug) {
                                    LOG.debug("Inbound message for address " + address + " rejected because is not authorised");
                                }
                            }
                        } else {
                            EventBusBridgeImpl.replyError(sock, "auth_error");
                            LOG.error("Error in performing authorization", res.cause());
                        }
                    });
                } else {
                    EventBusBridgeImpl.replyError(sock, "not_logged_in");
                    if (debug) {
                        LOG.debug("Inbound message for address " + address + " rejected because it requires auth and user is not authenticated");
                    }
                }
            } else {
                this.checkAndSend(send, address, body, headers, sock, replyAddress, awaitingReply);
            }
        } else {
            EventBusBridgeImpl.replyError(sock, "access_denied");
            if (debug) {
                LOG.debug("Inbound message for address " + address + " rejected because there is no match");
            }
        }
    }

    private void checkAndSend(boolean send, String address, Object body, JsonObject headers, SockJSSocket sock, String replyAddress, Message<?> awaitingReply) {
        MultiMap mHeaders;
        SockInfo info = this.sockInfos.get(sock);
        if (replyAddress != null && !this.checkMaxHandlers(sock, info)) {
            return;
        }
        Handler replyHandler = replyAddress != null ? result -> {
            if (result.succeeded()) {
                Message message = (Message)result.result();
                this.checkAddAccceptedReplyAddress(message);
                this.deliverMessage(sock, replyAddress, message);
            } else {
                ReplyException cause = (ReplyException)result.cause();
                JsonObject envelope = new JsonObject().put("type", "err").put("address", replyAddress).put("failureCode", cause.failureCode()).put("failureType", cause.failureType().name()).put("message", cause.getMessage());
                sock.write(Buffer.buffer(envelope.encode()));
            }
            --info.handlerCount;
        } : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding message to address " + address + " on event bus");
        }
        if (headers != null) {
            mHeaders = HttpHeaders.headers();
            headers.forEach(entry -> mHeaders.add((String)entry.getKey(), entry.getValue().toString()));
        } else {
            mHeaders = null;
        }
        if (send) {
            if (awaitingReply != null) {
                if (replyAddress != null) {
                    awaitingReply.replyAndRequest(body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders(mHeaders), replyHandler);
                } else {
                    awaitingReply.reply(body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders(mHeaders));
                }
            } else if (replyAddress != null) {
                this.eb.request(address, body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders(mHeaders), replyHandler);
            } else {
                this.eb.send(address, body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders(mHeaders));
            }
            if (replyAddress != null) {
                ++info.handlerCount;
            }
        } else {
            this.eb.publish(address, body, new DeliveryOptions().setHeaders(mHeaders));
        }
    }

    private void authorise(Match curMatch, User webUser, Handler<AsyncResult<Boolean>> handler) {
        if (curMatch.requiredAuthority.match(webUser)) {
            handler.handle(Future.succeededFuture(true));
            return;
        }
        if (this.authzProvider == null) {
            handler.handle(Future.succeededFuture(false));
            return;
        }
        this.authzProvider.getAuthorizations(webUser, res -> {
            if (res.succeeded()) {
                if (curMatch.requiredAuthority.match(webUser)) {
                    handler.handle(Future.succeededFuture(true));
                } else {
                    handler.handle(Future.succeededFuture(false));
                }
            } else {
                handler.handle(Future.failedFuture(res.cause()));
            }
        });
    }

    private Match checkMatches(boolean inbound, String address, Object body) {
        List<PermittedOptions> matches = inbound ? this.inboundPermitted : this.outboundPermitted;
        for (PermittedOptions matchHolder : matches) {
            boolean matched;
            String matchAddress = matchHolder.getAddress();
            String matchRegex = matchAddress == null ? matchHolder.getAddressRegex() : null;
            boolean addressOK = matchAddress == null ? matchRegex == null || this.regexMatches(matchRegex, address) : matchAddress.equals(address);
            if (!addressOK || !(matched = EventBusBridgeImpl.structureMatches(matchHolder.getMatch(), body))) continue;
            String requiredAuthority = matchHolder.getRequiredAuthority();
            return new Match(true, requiredAuthority);
        }
        return new Match(false);
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.compiledREs.computeIfAbsent(matchRegex, Pattern::compile);
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private static void replyError(SockJSSocket sock, String err) {
        JsonObject envelope = new JsonObject().put("type", "err").put("body", err);
        sock.write(Buffer.buffer(envelope.encode()));
    }

    private static boolean structureMatches(JsonObject match, Object bodyObject) {
        if (match == null || bodyObject == null) {
            return true;
        }
        if (bodyObject instanceof JsonObject) {
            JsonObject body = (JsonObject)bodyObject;
            for (String fieldName : match.fieldNames()) {
                Object mv = match.getValue(fieldName);
                Object bv = body.getValue(fieldName);
                if (!(mv instanceof JsonObject ? !EventBusBridgeImpl.structureMatches((JsonObject)mv, bv) : !match.getValue(fieldName).equals(body.getValue(fieldName)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static final class SockInfo {
        int handlerCount;
        PingInfo pingInfo;

        private SockInfo() {
        }
    }

    private static final class PingInfo {
        long lastPing;
        long timerID;

        private PingInfo() {
        }
    }

    private static class Match {
        public final boolean doesMatch;
        public final Authorization requiredAuthority;

        Match(boolean doesMatch, String requiredAuthority) {
            this.doesMatch = doesMatch;
            this.requiredAuthority = requiredAuthority == null ? null : PermissionBasedAuthorization.create((String)requiredAuthority);
        }

        Match(boolean doesMatch) {
            this.doesMatch = doesMatch;
            this.requiredAuthority = null;
        }
    }
}

