/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.mqtt;

import cc.iotkit.common.enums.ErrCode;
import cc.iotkit.common.exception.BizException;
import cc.iotkit.common.thing.ThingService;
import cc.iotkit.comp.AbstractDeviceComponent;
import cc.iotkit.comp.CompConfig;
import cc.iotkit.comp.model.DeviceState;
import cc.iotkit.comp.mqtt.MqttConfig;
import cc.iotkit.comp.mqtt.MqttVerticle;
import cc.iotkit.comp.mqtt.TransparentConverter;
import cc.iotkit.comp.mqtt.TransparentMsg;
import cc.iotkit.comp.utils.JsonUtil;
import cc.iotkit.converter.DeviceMessage;
import cc.iotkit.model.device.message.ThingModelMessage;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttDeviceComponent
extends AbstractDeviceComponent {
    private static final Logger log = LoggerFactory.getLogger(MqttDeviceComponent.class);
    private Vertx vertx;
    private CountDownLatch countDownLatch;
    private String deployedId;
    private MqttVerticle mqttVerticle;
    private final Map<String, Device> deviceChildToParent = new HashMap<String, Device>();
    private final TransparentConverter transparentConverter = new TransparentConverter();

    public void create(CompConfig config) {
        super.create(config);
        this.vertx = Vertx.vertx();
        MqttConfig mqttConfig = (MqttConfig)JsonUtil.parse((String)config.getOther(), MqttConfig.class);
        this.mqttVerticle = new MqttVerticle(mqttConfig);
    }

    public void start() {
        try {
            this.mqttVerticle.setExecutor(this.getHandler());
            this.countDownLatch = new CountDownLatch(1);
            Future<String> future = this.vertx.deployVerticle(this.mqttVerticle);
            future.onSuccess(s -> {
                this.deployedId = s;
                this.countDownLatch.countDown();
            });
            future.onFailure(e -> {
                this.countDownLatch.countDown();
                log.error("start mqtt component failed", e);
            });
            this.countDownLatch.await();
            future.succeeded();
        }
        catch (Throwable e2) {
            throw new BizException(ErrCode.COMPONENT_START_ERROR, e2);
        }
    }

    public void stop() {
        this.mqttVerticle.stop();
        Future<Void> future = this.vertx.undeploy(this.deployedId);
        future.onSuccess(unused -> log.info("stop mqtt component success"));
    }

    public void destroy() {
    }

    public void onDeviceStateChange(DeviceState state) {
        DeviceState.Parent parent = state.getParent();
        if (parent == null) {
            return;
        }
        Device device = new Device(state.getProductKey(), state.getDeviceName());
        if ("online".equals(state.getState())) {
            this.deviceChildToParent.put(device.toString(), new Device(parent.getProductKey(), parent.getDeviceName()));
        } else {
            this.deviceChildToParent.remove(device.toString());
        }
    }

    public DeviceMessage send(DeviceMessage message) {
        Object obj;
        Device child = new Device(message.getProductKey(), message.getDeviceName());
        Device parent = this.deviceChildToParent.get(child.toString());
        if (parent == null) {
            parent = child;
        }
        if (!((obj = message.getContent()) instanceof Map)) {
            throw new BizException(ErrCode.DATA_FORMAT_ERROR);
        }
        Message msg = new Message();
        try {
            BeanUtils.populate((Object)msg, (Map)((Map)obj));
        }
        catch (Throwable e) {
            throw new BizException(ErrCode.DATA_FORMAT_ERROR);
        }
        log.info("publish topic:{},payload:{}", (Object)msg.getTopic(), (Object)msg.getPayload());
        this.mqttVerticle.publish(parent.getProductKey(), parent.getDeviceName(), msg.getTopic(), msg.getPayload());
        return message;
    }

    public CompConfig getConfig() {
        return this.config;
    }

    public ThingModelMessage transparentDecode(Map<String, Object> msg) throws InvocationTargetException, IllegalAccessException {
        TransparentMsg transparentMsg = new TransparentMsg();
        BeanUtils.populate((Object)transparentMsg, msg);
        return this.transparentConverter.decode(transparentMsg);
    }

    public DeviceMessage transparentEncode(ThingService<?> service, cc.iotkit.converter.Device device) {
        return this.transparentConverter.encode(service, device);
    }

    public static class Device {
        private String productKey;
        private String deviceName;

        public String getProductKey() {
            return this.productKey;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setProductKey(String productKey) {
            this.productKey = productKey;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Device)) {
                return false;
            }
            Device other = (Device)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$productKey = this.getProductKey();
            String other$productKey = other.getProductKey();
            if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
                return false;
            }
            String this$deviceName = this.getDeviceName();
            String other$deviceName = other.getDeviceName();
            return !(this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Device;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $productKey = this.getProductKey();
            result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
            String $deviceName = this.getDeviceName();
            result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
            return result;
        }

        public Device() {
        }

        public Device(String productKey, String deviceName) {
            this.productKey = productKey;
            this.deviceName = deviceName;
        }

        public String toString() {
            return "MqttDeviceComponent.Device(productKey=" + this.getProductKey() + ", deviceName=" + this.getDeviceName() + ")";
        }
    }

    public static class Message {
        private String topic;
        private String payload;

        public String getTopic() {
            return this.topic;
        }

        public String getPayload() {
            return this.payload;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "MqttDeviceComponent.Message(topic=" + this.getTopic() + ", payload=" + this.getPayload() + ")";
        }
    }
}

