/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.analysis;

import cc.iotkit.comp.DLT645.analysis.DLT645Data;
import cc.iotkit.comp.DLT645.analysis.DLT645V1997Data;
import cc.iotkit.comp.DLT645.analysis.DLT645v1997CsvLoader;
import cc.iotkit.comp.DLT645.utils.ByteRef;
import cc.iotkit.comp.DLT645.utils.BytesRef;
import cc.iotkit.comp.DLT645.utils.ContainerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DLT645Analysis {
    private static final DLT645Analysis DLT645Analysis = new DLT645Analysis();
    public static final String ADR = "ADR";
    public static final String FUN = "FUN";
    public static final String DAT = "DAT";
    private Map<String, DLT645Data> name2entity;
    private Map<String, DLT645Data> din2entity;

    public static DLT645Analysis inst() {
        return DLT645Analysis;
    }

    private static int GetVfy(byte[] arrCmd, int iOffSet) {
        int iSize = arrCmd.length - 2 - iOffSet;
        if (iSize < 0) {
            return 0;
        }
        int bySum = 0;
        int index = iOffSet;
        for (int i = 0; i < iSize; ++i) {
            bySum += arrCmd[index++];
            bySum &= 0xFF;
        }
        return bySum & 0xFF;
    }

    public static byte[] packCmd(byte[] arrAddr, byte byCmd, byte[] arrData) {
        int iDataSize = arrData.length;
        if (iDataSize > 255) {
            return null;
        }
        if (arrAddr.length != 6) {
            return null;
        }
        byte[] arrCmd = new byte[iDataSize + 13];
        int index = 0;
        arrCmd[index++] = -2;
        arrCmd[index++] = 104;
        System.arraycopy(arrAddr, 0, arrCmd, index, arrAddr.length);
        index += arrAddr.length;
        arrCmd[index++] = 104;
        arrCmd[index++] = byCmd;
        arrCmd[index++] = (byte)iDataSize;
        System.arraycopy(arrData, 0, arrCmd, index, iDataSize);
        for (int i = 0; i < arrData.length; ++i) {
            arrCmd[index + i] = (byte)((arrCmd[index + i] & 0xFF) + 51);
        }
        index += iDataSize;
        arrCmd[index++] = (byte)cc.iotkit.comp.DLT645.analysis.DLT645Analysis.GetVfy(arrCmd, 1);
        arrCmd[index++] = 22;
        return arrCmd;
    }

    public static byte[] packCmd(byte byCmd, byte[] arrData) {
        byte[] arrAddr = new byte[]{1, 0, 0, 0, 0, 0};
        return cc.iotkit.comp.DLT645.analysis.DLT645Analysis.packCmd(arrAddr, byCmd, arrData);
    }

    private static boolean unPackCmd2Map(byte[] arrCmd, BytesRef arrAddrRef, ByteRef byCmd, BytesRef arrDataRef) {
        int iSize = arrCmd.length;
        int iOffSet = 0;
        int index = 0;
        for (iOffSet = 0; iOffSet < iSize && (arrCmd[index++] & 0xFF) != 104; ++iOffSet) {
        }
        if (iOffSet == iSize) {
            return false;
        }
        if (iSize < 12 + iOffSet) {
            return false;
        }
        if (arrCmd[iOffSet + 0] != 104) {
            return false;
        }
        if (arrCmd[iOffSet + 7] != 104) {
            return false;
        }
        if (arrCmd[iSize - 1] != 22) {
            return false;
        }
        byte[] arrAddr = new byte[6];
        System.arraycopy(arrCmd, iOffSet + 1, arrAddr, 0, 6);
        arrAddrRef.setValue(arrAddr);
        byCmd.setValue(arrCmd[iOffSet + 8]);
        byte iDataSize = arrCmd[iOffSet + 9];
        if (iDataSize + 12 + iOffSet != iSize) {
            return false;
        }
        byte[] arrData = new byte[iDataSize];
        System.arraycopy(arrCmd, iOffSet + 10, arrData, 0, iDataSize);
        for (int i = 0; i < arrData.length; ++i) {
            arrData[i] = (byte)((arrData[i] & 0xFF) - 51);
        }
        arrDataRef.setValue(arrData);
        byte byVfyOK = (byte)(cc.iotkit.comp.DLT645.analysis.DLT645Analysis.GetVfy(arrCmd, iOffSet) & 0xFF);
        return byVfyOK == arrCmd[iSize - 2];
    }

    public static boolean unPackCmd2Map(byte[] arrCmd, ByteRef byCmd, BytesRef arrData) {
        BytesRef arrAddr = new BytesRef();
        return cc.iotkit.comp.DLT645.analysis.DLT645Analysis.unPackCmd2Map(arrCmd, arrAddr, byCmd, arrData);
    }

    public static byte[] packCmdGetData(int DI0, int DI1) {
        byte[] arrData = new byte[]{(byte)DI0, (byte)DI1};
        return cc.iotkit.comp.DLT645.analysis.DLT645Analysis.packCmd((byte)1, arrData);
    }

    public static boolean unPackCmdGetData(byte[] arrCmd, BytesRef arrData) {
        ByteRef byCmd = new ByteRef();
        if (!cc.iotkit.comp.DLT645.analysis.DLT645Analysis.unPackCmd2Map(arrCmd, byCmd, arrData)) {
            return false;
        }
        return byCmd.getValue() == 129;
    }

    public static Map<String, Object> unPackCmd2Map(byte[] arrCmd) {
        BytesRef byAddr = new BytesRef();
        ByteRef byFun = new ByteRef();
        BytesRef arrData = new BytesRef();
        if (!cc.iotkit.comp.DLT645.analysis.DLT645Analysis.unPackCmd2Map(arrCmd, byAddr, byFun, arrData)) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put(ADR, byAddr.getValue());
        value.put(FUN, byFun.getValue());
        value.put(DAT, arrData.getValue());
        return value;
    }

    public synchronized Map<String, DLT645Data> getTemplateByName() {
        if (this.name2entity == null) {
            DLT645v1997CsvLoader loader = new DLT645v1997CsvLoader();
            List<DLT645Data> entityList = loader.loadCsvFile();
            Map nameMap = ContainerUtils.buildMapByKey(entityList, DLT645Data::getName);
            this.name2entity = new ConcurrentHashMap<String, DLT645Data>();
            this.name2entity.putAll(nameMap);
        }
        return this.name2entity;
    }

    public synchronized Map<String, DLT645Data> getTemplateByDIn() {
        if (this.din2entity == null) {
            DLT645v1997CsvLoader loader = new DLT645v1997CsvLoader();
            List<DLT645Data> entityList = loader.loadCsvFile();
            Map keyMap = ContainerUtils.buildMapByKey(entityList, DLT645V1997Data::getKey);
            this.din2entity = new ConcurrentHashMap<String, DLT645Data>();
            this.din2entity.putAll(keyMap);
        }
        return this.din2entity;
    }
}

