/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.analysis;

import cc.iotkit.common.enums.ErrCode;
import cc.iotkit.common.exception.BizException;
import cc.iotkit.comp.DLT645.utils.ByteUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DLT645DataFormat {
    public static final String FORMAT_X = "X";
    public static final String FORMAT_N = "N";
    public static final String FORMAT_YYMMDDWW = "YYMMDDWW";
    public static final String FORMAT_hhmmss = "hhmmss";
    public static final String FORMAT_YYMMDDhhmm = "YYMMDDhhmm";
    public static final String FORMAT_MMDDhhmm = "MMDDhhmm";
    public static final String FORMAT_DDhh = "DDhh";
    public static final String FORMAT_hhmm = "hhmm";
    public static final String FORMAT_mmmm = "mmmm";
    public static final String FORMAT_NN___NN = "NN...NN";
    public static final String FORMAT_XX___XX = "XX...XX";
    public static final String FORMAT_STATUS_WEEK = "\u5468\u4f11\u65e5\u72b6\u6001\u5b57";
    public static final String FORMAT_STATUS_METER = "\u7535\u8868\u8fd0\u884c\u72b6\u6001\u5b57";
    public static final String FORMAT_STATUS_NETWORK = "\u7535\u7f51\u72b6\u6001\u5b57";
    private String format = "";
    private String format2nd = "";
    private int length = 0;
    private int length2nd = 0;
    private double ratio = 1.0;

    public Object decodeValue(byte[] data, String format, int start, int length) throws RuntimeException {
        if (data.length < length + start) {
            throw new BizException(ErrCode.DATA_LENGTH_ERROR);
        }
        if (format.equals(FORMAT_X)) {
            return this.getValue(data, start, length, this.ratio);
        }
        if (format.equals(FORMAT_N)) {
            return this.getValue(data, start, length, this.ratio);
        }
        if (format.equals(FORMAT_NN___NN)) {
            return this.getString(data, start, length);
        }
        if (format.equals(FORMAT_hhmm) || format.equals(FORMAT_DDhh) || format.equals(FORMAT_YYMMDDWW) || format.equals(FORMAT_hhmmss) || format.equals(FORMAT_YYMMDDhhmm) || format.equals(FORMAT_MMDDhhmm)) {
            return this.getDataTime(data, format, start, length);
        }
        if (format.equals(FORMAT_XX___XX)) {
            this.format = FORMAT_XX___XX;
            this.ratio = 1.0;
            return true;
        }
        return false;
    }

    public boolean decodeFormat(String format, int length) {
        Map<Character, Integer> charCount = this.charCount(format);
        if (charCount.containsKey(Character.valueOf('|')) && charCount.get(Character.valueOf('|')).equals(1)) {
            String format1 = format.substring(0, format.indexOf("|"));
            String format2 = format.substring(format.indexOf("|") + 1);
            this.decodeFormat(format2, -1);
            this.format2nd = this.format;
            this.length2nd = this.length;
            this.decodeFormat(format1, -1);
            return true;
        }
        if (charCount.containsKey(Character.valueOf('X')) && charCount.containsKey(Character.valueOf('.')) && charCount.get(Character.valueOf('.')).equals(1)) {
            this.format = FORMAT_X;
            int point = format.length() - format.indexOf(".") - 1;
            for (int i = 0; i < point; ++i) {
                this.ratio *= 10.0;
            }
            this.length = (format.length() - 1) / 2;
            return true;
        }
        if (charCount.containsKey(Character.valueOf('X')) && charCount.size() == 1) {
            this.format = FORMAT_X;
            this.ratio = 1.0;
            this.length = length;
            return true;
        }
        if (charCount.containsKey(Character.valueOf('N')) && charCount.containsKey(Character.valueOf('.')) && charCount.get(Character.valueOf('.')).equals(1)) {
            this.format = FORMAT_N;
            int point = format.length() - format.indexOf(".") - 1;
            for (int i = 0; i < point; ++i) {
                this.ratio *= 10.0;
            }
            this.length = (format.length() - 1) / 2;
            return true;
        }
        if (charCount.containsKey(Character.valueOf('N')) && charCount.size() == 1) {
            this.format = FORMAT_N;
            this.ratio = 1.0;
            this.length = length;
            return true;
        }
        if (this.isFixedLength(format)) {
            this.format = format;
            this.ratio = 1.0;
            this.length = format.length() / 2;
            return true;
        }
        if (this.isVariableLength(format)) {
            this.format = format;
            this.ratio = 1.0;
            this.length = length;
            return true;
        }
        return false;
    }

    private boolean isFixedLength(String format) {
        if (format.equalsIgnoreCase(FORMAT_hhmm)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_DDhh)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_MMDDhhmm)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_YYMMDDhhmm)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_hhmmss)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_mmmm)) {
            return true;
        }
        return format.equalsIgnoreCase(FORMAT_YYMMDDWW);
    }

    private boolean isVariableLength(String format) {
        if (format.equalsIgnoreCase(FORMAT_NN___NN)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_XX___XX)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_STATUS_METER)) {
            return true;
        }
        if (format.equalsIgnoreCase(FORMAT_STATUS_NETWORK)) {
            return true;
        }
        return format.equalsIgnoreCase(FORMAT_STATUS_WEEK);
    }

    private Map<Character, Integer> charCount(String format) {
        HashMap<Character, Integer> charSet = new HashMap<Character, Integer>();
        for (int i = 0; i < format.length(); ++i) {
            Character ch = Character.valueOf(format.charAt(i));
            Integer count = (Integer)charSet.get(ch);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            charSet.put(ch, count);
        }
        return charSet;
    }

    private Object getValue(byte[] data, int start, int length, double ratio) {
        long sum = 0L;
        double rd = 1.0;
        for (int i = 0; i < length; ++i) {
            long l = data[start + i] & 0xF;
            long h = (data[start + i] & 0xF0) >> 4;
            l = (long)((double)l * rd);
            sum += l;
            h = (long)((double)h * (rd *= 10.0));
            sum += h;
            rd *= 10.0;
        }
        if (ratio < 1.1 && ratio > 0.0) {
            return sum;
        }
        return (double)sum / ratio;
    }

    private String getDataTime(byte[] data, String format, int start, int length) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            Integer l = data[start + i] & 0xF;
            Integer h = (data[start + i] & 0xF0) >> 4;
            list.add(l.toString());
            list.add(h.toString());
        }
        if (format.equals(FORMAT_YYMMDDhhmm)) {
            String result = "20" + (String)list.get(9) + (String)list.get(8) + "\u5e74" + (String)list.get(7) + (String)list.get(6) + "\u6708" + (String)list.get(5) + (String)list.get(4) + "\u65e5";
            result = result + " " + (String)list.get(3) + (String)list.get(2) + "\u70b9" + (String)list.get(1) + (String)list.get(0) + "\u5206";
            return result;
        }
        if (format.equals(FORMAT_YYMMDDWW)) {
            String result = "20" + (String)list.get(7) + (String)list.get(6) + "\u5e74" + (String)list.get(5) + (String)list.get(4) + "\u6708" + (String)list.get(3) + (String)list.get(2) + "\u65e5";
            result = result + " \u661f\u671f:" + (String)list.get(1) + (String)list.get(0);
            return result;
        }
        if (format.equals(FORMAT_hhmmss)) {
            String result = (String)list.get(5) + (String)list.get(4) + "\u70b9" + (String)list.get(3) + (String)list.get(2) + "\u5206" + (String)list.get(1) + (String)list.get(0) + "\u79d2";
            return result;
        }
        if (format.equals(FORMAT_mmmm)) {
            String result = (String)list.get(3) + (String)list.get(2) + (String)list.get(1) + (String)list.get(0) + "\u5206";
            return result;
        }
        if (format.equals(FORMAT_MMDDhhmm)) {
            String result = (String)list.get(7) + (String)list.get(6) + "\u6708" + (String)list.get(5) + (String)list.get(4) + "\u65e5 ";
            result = result + (String)list.get(3) + (String)list.get(2) + "\u70b9" + (String)list.get(1) + (String)list.get(0) + "\u5206";
            return result;
        }
        if (format.equals(FORMAT_DDhh)) {
            String result = (String)list.get(3) + (String)list.get(2) + "\u53f7 " + (String)list.get(1) + (String)list.get(0) + "\u70b9";
            return result;
        }
        if (format.equals(FORMAT_hhmm)) {
            String result = (String)list.get(3) + (String)list.get(2) + "\u70b9 " + (String)list.get(1) + (String)list.get(0) + "\u5206";
            return result;
        }
        return "";
    }

    private byte encodeBCD(byte a) {
        return (byte)(a / 10 * 16 + a % 10);
    }

    private byte decodeBCD(byte a) {
        return (byte)(a / 16 * 10 + a % 16);
    }

    private Object getString(byte[] data, int start, int length) {
        int i;
        byte[] tmp = new byte[length];
        for (i = 0; i < length; ++i) {
            tmp[i] = data[start + i];
        }
        for (i = 0; i < length / 2; ++i) {
            byte by = tmp[i];
            tmp[i] = tmp[length - i - 1];
            tmp[length - i - 1] = by;
        }
        return ByteUtils.byteArrayToHexString(tmp, true).replace(" ", "");
    }

    public String getFormat() {
        return this.format;
    }

    public String getFormat2nd() {
        return this.format2nd;
    }

    public int getLength() {
        return this.length;
    }

    public int getLength2nd() {
        return this.length2nd;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFormat2nd(String format2nd) {
        this.format2nd = format2nd;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLength2nd(int length2nd) {
        this.length2nd = length2nd;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DLT645DataFormat)) {
            return false;
        }
        DLT645DataFormat other = (DLT645DataFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getLength2nd() != other.getLength2nd()) {
            return false;
        }
        if (Double.compare(this.getRatio(), other.getRatio()) != 0) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$format2nd = this.getFormat2nd();
        String other$format2nd = other.getFormat2nd();
        return !(this$format2nd == null ? other$format2nd != null : !this$format2nd.equals(other$format2nd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DLT645DataFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLength();
        result = result * 59 + this.getLength2nd();
        long $ratio = Double.doubleToLongBits(this.getRatio());
        result = result * 59 + (int)($ratio >>> 32 ^ $ratio);
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $format2nd = this.getFormat2nd();
        result = result * 59 + ($format2nd == null ? 43 : $format2nd.hashCode());
        return result;
    }

    public String toString() {
        return "DLT645DataFormat(format=" + this.getFormat() + ", format2nd=" + this.getFormat2nd() + ", length=" + this.getLength() + ", length2nd=" + this.getLength2nd() + ", ratio=" + this.getRatio() + ")";
    }
}

