/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;

public class LuaInteger
extends LuaNumber {
    private static final LuaInteger[] intValues = new LuaInteger[512];
    public final int v;

    public static LuaInteger valueOf(int n) {
        return n <= 255 && n >= -256 ? intValues[n + 256] : new LuaInteger(n);
    }

    public static LuaNumber valueOf(long l) {
        int n = (int)l;
        return l == (long)n ? (n <= 255 && n >= -256 ? intValues[n + 256] : new LuaInteger(n)) : LuaDouble.valueOf(l);
    }

    LuaInteger(int n) {
        this.v = n;
    }

    public boolean isint() {
        return true;
    }

    public boolean isinttype() {
        return true;
    }

    public boolean islong() {
        return true;
    }

    public byte tobyte() {
        return (byte)this.v;
    }

    public char tochar() {
        return (char)this.v;
    }

    public double todouble() {
        return this.v;
    }

    public float tofloat() {
        return this.v;
    }

    public int toint() {
        return this.v;
    }

    public long tolong() {
        return this.v;
    }

    public short toshort() {
        return (short)this.v;
    }

    public double optdouble(double d) {
        return this.v;
    }

    public int optint(int n) {
        return this.v;
    }

    public LuaInteger optinteger(LuaInteger luaInteger) {
        return this;
    }

    public long optlong(long l) {
        return this.v;
    }

    public String tojstring() {
        return Integer.toString(this.v);
    }

    public LuaString strvalue() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    public LuaString optstring(LuaString luaString) {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    public LuaValue tostring() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    public String optjstring(String string) {
        return Integer.toString(this.v);
    }

    public LuaInteger checkinteger() {
        return this;
    }

    public boolean isstring() {
        return true;
    }

    public int hashCode() {
        return this.v;
    }

    public static int hashCode(int n) {
        return n;
    }

    public LuaValue neg() {
        return LuaInteger.valueOf(-((long)this.v));
    }

    public boolean equals(Object object) {
        return object instanceof LuaInteger ? ((LuaInteger)object).v == this.v : false;
    }

    public LuaValue eq(LuaValue luaValue) {
        return luaValue.raweq(this.v) ? TRUE : FALSE;
    }

    public boolean eq_b(LuaValue luaValue) {
        return luaValue.raweq(this.v);
    }

    public boolean raweq(LuaValue luaValue) {
        return luaValue.raweq(this.v);
    }

    public boolean raweq(double d) {
        return (double)this.v == d;
    }

    public boolean raweq(int n) {
        return this.v == n;
    }

    public LuaValue add(LuaValue luaValue) {
        return luaValue.add(this.v);
    }

    public LuaValue add(double d) {
        return LuaDouble.valueOf(d + (double)this.v);
    }

    public LuaValue add(int n) {
        return LuaInteger.valueOf((long)n + (long)this.v);
    }

    public LuaValue sub(LuaValue luaValue) {
        return luaValue.subFrom(this.v);
    }

    public LuaValue sub(double d) {
        return LuaDouble.valueOf((double)this.v - d);
    }

    public LuaValue sub(int n) {
        return LuaDouble.valueOf(this.v - n);
    }

    public LuaValue subFrom(double d) {
        return LuaDouble.valueOf(d - (double)this.v);
    }

    public LuaValue subFrom(int n) {
        return LuaInteger.valueOf((long)n - (long)this.v);
    }

    public LuaValue mul(LuaValue luaValue) {
        return luaValue.mul(this.v);
    }

    public LuaValue mul(double d) {
        return LuaDouble.valueOf(d * (double)this.v);
    }

    public LuaValue mul(int n) {
        return LuaInteger.valueOf((long)n * (long)this.v);
    }

    public LuaValue pow(LuaValue luaValue) {
        return luaValue.powWith(this.v);
    }

    public LuaValue pow(double d) {
        return MathLib.dpow(this.v, d);
    }

    public LuaValue pow(int n) {
        return MathLib.dpow(this.v, n);
    }

    public LuaValue powWith(double d) {
        return MathLib.dpow(d, this.v);
    }

    public LuaValue powWith(int n) {
        return MathLib.dpow(n, this.v);
    }

    public LuaValue div(LuaValue luaValue) {
        return luaValue.divInto(this.v);
    }

    public LuaValue div(double d) {
        return LuaDouble.ddiv(this.v, d);
    }

    public LuaValue div(int n) {
        return LuaDouble.ddiv(this.v, n);
    }

    public LuaValue divInto(double d) {
        return LuaDouble.ddiv(d, this.v);
    }

    public LuaValue mod(LuaValue luaValue) {
        return luaValue.modFrom(this.v);
    }

    public LuaValue mod(double d) {
        return LuaDouble.dmod(this.v, d);
    }

    public LuaValue mod(int n) {
        return LuaDouble.dmod(this.v, n);
    }

    public LuaValue modFrom(double d) {
        return LuaDouble.dmod(d, this.v);
    }

    public LuaValue lt(LuaValue luaValue) {
        return luaValue.gt_b(this.v) ? TRUE : FALSE;
    }

    public LuaValue lt(double d) {
        return (double)this.v < d ? TRUE : FALSE;
    }

    public LuaValue lt(int n) {
        return this.v < n ? TRUE : FALSE;
    }

    public boolean lt_b(LuaValue luaValue) {
        return luaValue.gt_b(this.v);
    }

    public boolean lt_b(int n) {
        return this.v < n;
    }

    public boolean lt_b(double d) {
        return (double)this.v < d;
    }

    public LuaValue lteq(LuaValue luaValue) {
        return luaValue.gteq_b(this.v) ? TRUE : FALSE;
    }

    public LuaValue lteq(double d) {
        return (double)this.v <= d ? TRUE : FALSE;
    }

    public LuaValue lteq(int n) {
        return this.v <= n ? TRUE : FALSE;
    }

    public boolean lteq_b(LuaValue luaValue) {
        return luaValue.gteq_b(this.v);
    }

    public boolean lteq_b(int n) {
        return this.v <= n;
    }

    public boolean lteq_b(double d) {
        return (double)this.v <= d;
    }

    public LuaValue gt(LuaValue luaValue) {
        return luaValue.lt_b(this.v) ? TRUE : FALSE;
    }

    public LuaValue gt(double d) {
        return (double)this.v > d ? TRUE : FALSE;
    }

    public LuaValue gt(int n) {
        return this.v > n ? TRUE : FALSE;
    }

    public boolean gt_b(LuaValue luaValue) {
        return luaValue.lt_b(this.v);
    }

    public boolean gt_b(int n) {
        return this.v > n;
    }

    public boolean gt_b(double d) {
        return (double)this.v > d;
    }

    public LuaValue gteq(LuaValue luaValue) {
        return luaValue.lteq_b(this.v) ? TRUE : FALSE;
    }

    public LuaValue gteq(double d) {
        return (double)this.v >= d ? TRUE : FALSE;
    }

    public LuaValue gteq(int n) {
        return this.v >= n ? TRUE : FALSE;
    }

    public boolean gteq_b(LuaValue luaValue) {
        return luaValue.lteq_b(this.v);
    }

    public boolean gteq_b(int n) {
        return this.v >= n;
    }

    public boolean gteq_b(double d) {
        return (double)this.v >= d;
    }

    public int strcmp(LuaString luaString) {
        this.typerror("attempt to compare number with string");
        return 0;
    }

    public int checkint() {
        return this.v;
    }

    public long checklong() {
        return this.v;
    }

    public double checkdouble() {
        return this.v;
    }

    public String checkjstring() {
        return String.valueOf(this.v);
    }

    public LuaString checkstring() {
        return LuaInteger.valueOf(String.valueOf(this.v));
    }

    static {
        for (int i = 0; i < 512; ++i) {
            LuaInteger.intValues[i] = new LuaInteger(i - 256);
        }
    }
}

