/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.websocket;

import cc.iotkit.common.enums.ErrCode;
import cc.iotkit.common.exception.BizException;
import cc.iotkit.common.utils.JsonUtils;
import cc.iotkit.comp.AbstractDeviceComponent;
import cc.iotkit.comp.CompConfig;
import cc.iotkit.comp.model.DeviceState;
import cc.iotkit.comp.websocket.AbstractDeviceVerticle;
import cc.iotkit.comp.websocket.client.WebSocketClientVerticle;
import cc.iotkit.comp.websocket.server.WebSocketServerVerticle;
import cc.iotkit.converter.DeviceMessage;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketDeviceComponent
extends AbstractDeviceComponent {
    private static final Logger log = LoggerFactory.getLogger(WebSocketDeviceComponent.class);
    private Vertx vertx;
    private CountDownLatch countDownLatch;
    private String deployedId;
    private AbstractDeviceVerticle webSocketVerticle;
    private final Map<String, Device> deviceChildToParent = new HashMap<String, Device>();

    public void create(CompConfig config) {
        super.create(config);
        this.vertx = Vertx.vertx();
        String type = ((Map)JsonUtils.parseObject((String)config.getOther(), Map.class)).get("type").toString();
        this.webSocketVerticle = "client".equals(type) ? new WebSocketClientVerticle(config.getOther()) : new WebSocketServerVerticle(config.getOther());
    }

    public void start() {
        try {
            this.webSocketVerticle.setExecutor(this.getHandler());
            this.countDownLatch = new CountDownLatch(1);
            Future<String> future = this.vertx.deployVerticle(this.webSocketVerticle);
            future.onSuccess(s -> {
                this.deployedId = s;
                this.countDownLatch.countDown();
            });
            future.onFailure(e -> {
                this.countDownLatch.countDown();
                log.error("start websocket component failed", e);
            });
            this.countDownLatch.await();
            future.succeeded();
        }
        catch (Throwable e2) {
            throw new BizException(ErrCode.COMPONENT_START_ERROR, e2);
        }
    }

    public void stop() {
        this.webSocketVerticle.stop();
        Future<Void> future = this.vertx.undeploy(this.deployedId);
        future.onSuccess(unused -> log.info("stop websocket component success"));
    }

    public void destroy() {
    }

    public void onDeviceStateChange(DeviceState state) {
        DeviceState.Parent parent = state.getParent();
        if (parent == null) {
            return;
        }
        Device device = new Device(state.getProductKey(), state.getDeviceName());
        if ("online".equals(state.getState())) {
            this.deviceChildToParent.put(device.toString(), new Device(parent.getProductKey(), parent.getDeviceName()));
        } else {
            this.deviceChildToParent.remove(device.toString());
        }
    }

    public DeviceMessage send(DeviceMessage message) {
        this.webSocketVerticle.send(message);
        return message;
    }

    public CompConfig getConfig() {
        return this.config;
    }

    public static class Device {
        private String productKey;
        private String deviceName;

        public String getProductKey() {
            return this.productKey;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setProductKey(String productKey) {
            this.productKey = productKey;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Device)) {
                return false;
            }
            Device other = (Device)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$productKey = this.getProductKey();
            String other$productKey = other.getProductKey();
            if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
                return false;
            }
            String this$deviceName = this.getDeviceName();
            String other$deviceName = other.getDeviceName();
            return !(this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Device;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $productKey = this.getProductKey();
            result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
            String $deviceName = this.getDeviceName();
            result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
            return result;
        }

        public Device() {
        }

        public Device(String productKey, String deviceName) {
            this.productKey = productKey;
            this.deviceName = deviceName;
        }

        public String toString() {
            return "WebSocketDeviceComponent.Device(productKey=" + this.getProductKey() + ", deviceName=" + this.getDeviceName() + ")";
        }
    }
}

