/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.tracing.TagExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpUtils {
    static final int SC_SWITCHING_PROTOCOLS = 101;
    static final int SC_BAD_GATEWAY = 502;
    static final TagExtractor<HttpServerRequest> SERVER_REQUEST_TAG_EXTRACTOR = new TagExtractor<HttpServerRequest>(){

        @Override
        public int len(HttpServerRequest req) {
            return 2;
        }

        @Override
        public String name(HttpServerRequest req, int index) {
            switch (index) {
                case 0: {
                    return "http.url";
                }
                case 1: {
                    return "http.method";
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpServerRequest req, int index) {
            switch (index) {
                case 0: {
                    return req.absoluteURI();
                }
                case 1: {
                    return req.method().name();
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpServerResponse> SERVER_RESPONSE_TAG_EXTRACTOR = new TagExtractor<HttpServerResponse>(){

        @Override
        public int len(HttpServerResponse resp) {
            return 1;
        }

        @Override
        public String name(HttpServerResponse resp, int index) {
            if (index == 0) {
                return "http.status_code";
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpServerResponse resp, int index) {
            if (index == 0) {
                return "" + resp.getStatusCode();
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpRequestHead> CLIENT_HTTP_REQUEST_TAG_EXTRACTOR = new TagExtractor<HttpRequestHead>(){

        @Override
        public int len(HttpRequestHead req) {
            return 2;
        }

        @Override
        public String name(HttpRequestHead req, int index) {
            switch (index) {
                case 0: {
                    return "http.url";
                }
                case 1: {
                    return "http.method";
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpRequestHead req, int index) {
            switch (index) {
                case 0: {
                    return req.absoluteURI;
                }
                case 1: {
                    return req.method.name();
                }
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final TagExtractor<HttpResponseHead> CLIENT_RESPONSE_TAG_EXTRACTOR = new TagExtractor<HttpResponseHead>(){

        @Override
        public int len(HttpResponseHead resp) {
            return 1;
        }

        @Override
        public String name(HttpResponseHead resp, int index) {
            if (index == 0) {
                return "http.status_code";
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }

        @Override
        public String value(HttpResponseHead resp, int index) {
            if (index == 0) {
                return "" + resp.statusCode;
            }
            throw new IndexOutOfBoundsException("Invalid tag index " + index);
        }
    };
    static final StreamPriority DEFAULT_STREAM_PRIORITY = new StreamPriority(){

        @Override
        public StreamPriority setWeight(short weight) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setDependency(int dependency) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setExclusive(boolean exclusive) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }
    };
    private static final CustomCompressor compressor = new CustomCompressor();
    private static final AsciiString TIMEOUT_EQ = AsciiString.of((CharSequence)"timeout=");
    private static final Consumer<CharSequence> HEADER_VALUE_VALIDATOR = HttpUtils::validateHeaderValue;
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -16;

    private HttpUtils() {
    }

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(CharSequence path, int start, String what) {
        return HttpUtils.matches(path, start, what, false);
    }

    private static boolean matches(CharSequence path, int start, String what, boolean exact) {
        if (exact && path.length() - start != what.length()) {
            return false;
        }
        if (path.length() - start >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path.charAt(start + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizePath(String pathname) {
        if (pathname == null) {
            return null;
        }
        if (pathname.length() == 0) {
            return "/";
        }
        StringBuilder ibuf = new StringBuilder(pathname.length() + 1);
        if (pathname.charAt(0) != '/') {
            ibuf.append('/');
        }
        ibuf.append(pathname);
        for (int i = 0; i < ibuf.length(); ++i) {
            if (ibuf.charAt(i) != '%') continue;
            HttpUtils.decodeUnreserved(ibuf, i);
        }
        return HttpUtils.removeDots(ibuf);
    }

    private static void decodeUnreserved(StringBuilder path, int start) {
        if (start + 3 <= path.length()) {
            int unescaped;
            String escapeSequence = path.substring(start + 1, start + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence, 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                path.setCharAt(start, (char)unescaped);
                path.delete(start + 1, start + 3);
            }
        } else {
            throw new IllegalArgumentException("Invalid position for escape character: " + start);
        }
    }

    public static String removeDots(CharSequence path) {
        if (path == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path.length());
        int i = 0;
        while (i < path.length()) {
            int pos;
            if (HttpUtils.matches(path, i, "./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path, i, "../")) {
                i += 3;
                continue;
            }
            if (HttpUtils.matches(path, i, "/./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path, i, "/.", true)) {
                path = "/";
                i = 0;
                continue;
            }
            if (HttpUtils.matches(path, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path, i, "/..", true)) {
                path = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path, i, ".", true) || HttpUtils.matches(path, i, "..", true)) break;
            if (path.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = HttpUtils.indexOfSlash(path, i)) != -1) {
                obuf.append(path, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path, i, path.length());
            break;
        }
        return obuf.toString();
    }

    public static URI resolveURIReference(String base, String ref) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref);
    }

    public static URI resolveURIReference(URI base, String ref) throws URISyntaxException {
        String query;
        String path;
        String authority;
        String scheme;
        URI _ref = URI.create(ref);
        if (_ref.getScheme() != null) {
            scheme = _ref.getScheme();
            authority = _ref.getAuthority();
            path = HttpUtils.removeDots(_ref.getRawPath());
            query = _ref.getRawQuery();
        } else {
            if (_ref.getAuthority() != null) {
                authority = _ref.getAuthority();
                path = _ref.getRawPath();
                query = _ref.getRawQuery();
            } else {
                if (_ref.getRawPath().length() == 0) {
                    path = base.getRawPath();
                    query = _ref.getRawQuery() != null ? _ref.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref.getRawPath().startsWith("/")) {
                        path = HttpUtils.removeDots(_ref.getRawPath());
                    } else {
                        int index;
                        String basePath = base.getRawPath();
                        String mergedPath = base.getAuthority() != null && basePath.length() == 0 ? "/" + _ref.getRawPath() : ((index = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index + 1) + _ref.getRawPath() : _ref.getRawPath());
                        path = HttpUtils.removeDots(mergedPath);
                    }
                    query = _ref.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path, query, _ref.getFragment());
    }

    static String parsePath(String uri) {
        int i;
        if (uri.length() == 0) {
            return "";
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map prms = queryStringDecoder.parameters();
        MultiMap params = MultiMap.caseInsensitiveMultiMap();
        if (!prms.isEmpty()) {
            for (Map.Entry entry : prms.entrySet()) {
                params.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', Long.valueOf(vertxSettings.getHeaderTableSize()));
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != Integer.MAX_VALUE) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set(key.charValue(), (long)value);
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len2 = buffer.length();
            for (int pos = 0; pos < len2; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, Long.valueOf(j));
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort(c.charValue());
            buffer.appendUnsignedInt((long)l);
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer((CharSequence)reason, (Charset)StandardCharsets.UTF_8)});
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static void sendError(Channel ch, HttpResponseStatus status2) {
        HttpUtils.sendError(ch, status2, status2.reasonPhrase());
    }

    static void sendError(Channel ch, HttpResponseStatus status2, CharSequence err) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status2);
        if (status2.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            HttpUtil.setContentLength((HttpMessage)resp, (long)err.length());
        } else {
            HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
        }
        ch.writeAndFlush((Object)resp);
    }

    static String getWebSocketLocation(HttpServerRequest req, boolean ssl) throws Exception {
        String prefix = ssl ? "wss://" : "ws://";
        URI uri = new URI(req.uri());
        String path = uri.getRawPath();
        String loc = prefix + req.headers().get((CharSequence)HttpHeaderNames.HOST) + path;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    public static CharSequence toLowerCase(CharSequence sequence) {
        StringBuilder buffer = null;
        int len2 = sequence.length();
        for (int index = 0; index < len2; ++index) {
            char c = sequence.charAt(index);
            if (c < 'A' || c > 'Z') continue;
            if (buffer == null) {
                buffer = new StringBuilder(sequence);
            }
            buffer.setCharAt(index, (char)(c + 32));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return sequence;
    }

    static String determineContentEncoding(Http2Headers headers) {
        ZlibWrapper wrapper2;
        String acceptEncoding;
        String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && (wrapper2 = compressor.determineWrapper(acceptEncoding)) != null) {
            switch (wrapper2) {
                case GZIP: {
                    return "gzip";
                }
                case ZLIB: {
                    return "deflate";
                }
            }
        }
        return null;
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }

    static HttpMethod toVertxMethod(String method) {
        return HttpMethod.valueOf(method);
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len2 = value.length();
        int pos = 0;
        while (pos < len2) {
            int to;
            int next2;
            int idx = AsciiString.indexOf((CharSequence)value, (char)',', (int)pos);
            if (idx == -1) {
                idx = next2 = len2;
            } else {
                next2 = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches((CharSequence)value, (boolean)true, (int)pos, (CharSequence)TIMEOUT_EQ, (int)0, (int)TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next2;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        HttpUtils.validateHeaderName(name);
        if (value != null) {
            HttpUtils.validateHeaderValue(value);
        }
    }

    public static void validateHeader(CharSequence name, Iterable<? extends CharSequence> values) {
        HttpUtils.validateHeaderName(name);
        values.forEach(value -> {
            if (value != null) {
                HEADER_VALUE_VALIDATOR.accept((CharSequence)value);
            }
        });
    }

    public static void validateHeaderValue(CharSequence seq) {
        int state = 0;
        for (int index = 0; index < seq.length(); ++index) {
            state = HttpUtils.validateValueChar(seq, state, seq.charAt(index));
        }
        if (state != 0) {
            throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
        }
    }

    private static int validateValueChar(CharSequence seq, int state, char character) {
        if ((character & 0xFFFFFFF0) == 0) {
            switch (character) {
                case '\u0000': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\u0000': " + seq);
                }
                case '\u000b': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + seq);
                }
                case '\f': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + seq);
                }
            }
        }
        switch (state) {
            case 0: {
                switch (character) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                switch (character) {
                    case '\n': {
                        return 2;
                    }
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + seq);
            }
            case 2: {
                switch (character) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + seq);
            }
        }
        return state;
    }

    public static void validateHeaderName(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + value);
                }
            }
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + value);
        }
    }

    public static boolean isValidMultipartContentType(String contentType) {
        return HttpHeaderValues.MULTIPART_FORM_DATA.regionMatches(true, 0, (CharSequence)contentType, 0, HttpHeaderValues.MULTIPART_FORM_DATA.length()) || HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.regionMatches(true, 0, (CharSequence)contentType, 0, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.length());
    }

    public static boolean isValidMultipartMethod(io.netty.handler.codec.http.HttpMethod method) {
        return method.equals((Object)io.netty.handler.codec.http.HttpMethod.POST) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PUT) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PATCH) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.DELETE);
    }

    static void resolveFile(VertxInternal vertx, String filename, long offset, long length, Handler<AsyncResult<AsyncFile>> resultHandler) {
        File file_ = vertx.resolveFile(filename);
        if (!file_.exists()) {
            resultHandler.handle(Future.failedFuture(new FileNotFoundException()));
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file_, "r");){
            FileSystem fs = vertx.fileSystem();
            fs.open(filename, new OpenOptions().setCreate(false).setWrite(false), ar -> {
                if (ar.succeeded()) {
                    AsyncFile file = (AsyncFile)ar.result();
                    long contentLength = Math.min(length, file_.length() - offset);
                    file.setReadPos(offset);
                    file.setReadLength(contentLength);
                }
                resultHandler.handle((AsyncResult<AsyncFile>)ar);
            });
        }
        catch (IOException e) {
            resultHandler.handle(Future.failedFuture(e));
        }
    }

    static boolean isConnectOrUpgrade(HttpMethod method, MultiMap headers) {
        return method == HttpMethod.CONNECT || method == HttpMethod.GET && headers.contains(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE, true);
    }

    private static class CustomCompressor
    extends HttpContentCompressor {
        private CustomCompressor() {
        }

        public ZlibWrapper determineWrapper(String acceptEncoding) {
            return super.determineWrapper(acceptEncoding);
        }
    }
}

