/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.websocket.server;

import cc.iotkit.common.exception.BizException;
import cc.iotkit.common.utils.JsonUtil;
import cc.iotkit.comp.websocket.AbstractDeviceVerticle;
import cc.iotkit.comp.websocket.server.WebSocketServerConfig;
import cc.iotkit.converter.DeviceMessage;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.PemKeyCertOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerVerticle
extends AbstractDeviceVerticle {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerVerticle.class);
    private HttpServer httpServer;
    private WebSocketServerConfig webSocketConfig;
    private final Map<String, ServerWebSocket> wsClients = new ConcurrentHashMap<String, ServerWebSocket>();
    private Map<String, String> tokens = new HashMap<String, String>();

    public WebSocketServerVerticle(String config) {
        this.webSocketConfig = (WebSocketServerConfig)JsonUtil.parse((String)config, WebSocketServerConfig.class);
    }

    @Override
    public void start() throws Exception {
        HttpServerOptions options = new HttpServerOptions().setPort(this.webSocketConfig.getPort());
        if (this.webSocketConfig.isSsl()) {
            options = options.setSsl(true).setKeyCertOptions(new PemKeyCertOptions().setKeyPath(this.webSocketConfig.getSslKey()).setCertPath(this.webSocketConfig.getSslCert()));
        }
        this.httpServer = this.vertx.createHttpServer(options).webSocketHandler(wsClient -> {
            log.info("webSocket client connect sessionId:{},path={}", (Object)wsClient.textHandlerID(), (Object)wsClient.path());
            String deviceKey = wsClient.path().replace("/", "");
            if (StringUtils.isBlank((CharSequence)deviceKey) || deviceKey.split("_").length != 2) {
                log.warn("\u964c\u751f\u8fde\u63a5\uff0c\u62d2\u7edd");
                wsClient.reject();
                return;
            }
            wsClient.writeTextMessage("connect succes! please auth!");
            HashMap<String, String> deviceKeyObj = new HashMap<String, String>();
            deviceKeyObj.put("deviceKey", deviceKey);
            wsClient.textMessageHandler(message -> {
                HashMap msg = (HashMap)JsonUtil.parse((String)message, HashMap.class);
                if (this.wsClients.containsKey(deviceKey)) {
                    if ("ping".equals(msg.get("type"))) {
                        msg.put("type", "pong");
                        wsClient.writeTextMessage(JsonUtil.toJsonString((Object)msg));
                        return;
                    }
                    if ("register".equals(msg.get("type"))) {
                        this.executor.onReceive(new HashMap(), "", message, r -> {
                            if (r == null) {
                                HashMap<String, String> ret = new HashMap<String, String>();
                                ret.put("id", (String)msg.get("id"));
                                ret.put("type", (String)msg.get("type"));
                                ret.put("result", "fail");
                                wsClient.writeTextMessage(JsonUtil.toJsonString(ret));
                                return;
                            }
                            msg.put("type", "online");
                            this.executor.onReceive(new HashMap(), "", JsonUtil.toJsonString((Object)msg));
                        });
                    }
                } else {
                    if (msg != null && "auth".equals(msg.get("type"))) {
                        Set<String> tokenKey = this.tokens.keySet();
                        for (String key : tokenKey) {
                            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)msg.get(key))) || !this.tokens.get(key).equals(msg.get(key))) continue;
                            log.info("\u8ba4\u8bc1\u901a\u8fc7");
                            this.wsClients.put(deviceKey, (ServerWebSocket)wsClient);
                            wsClient.writeTextMessage("auth succes");
                            return;
                        }
                        log.warn("\u8ba4\u8bc1\u5931\u8d25\uff0c\u62d2\u7edd");
                        wsClient.writeTextMessage("auth fail");
                        return;
                    }
                    log.warn("\u8ba4\u8bc1\u5931\u8d25\uff0c\u62d2\u7edd");
                    wsClient.writeTextMessage("auth fail");
                    return;
                }
            });
            wsClient.closeHandler(c -> {
                log.warn("client connection closed,deviceKey:{}", (Object)deviceKey);
                if (this.wsClients.containsKey(deviceKey)) {
                    this.wsClients.remove(deviceKey);
                    deviceKeyObj.put("type", "offline");
                    this.executor.onReceive(new HashMap(), "", JsonUtil.toJsonString((Object)deviceKeyObj), r -> {});
                }
            });
            wsClient.exceptionHandler(ex -> {
                log.warn("webSocket client connection exception,deviceKey:{}", (Object)deviceKey);
                if (this.wsClients.containsKey(deviceKey)) {
                    this.wsClients.remove(deviceKey);
                    deviceKeyObj.put("type", "offline");
                    this.executor.onReceive(new HashMap(), "", JsonUtil.toJsonString((Object)deviceKeyObj), r -> {});
                }
            });
        }).listen(this.webSocketConfig.getPort(), server -> {
            if (server.succeeded()) {
                log.info("webSocket server is listening on port " + this.webSocketConfig.getPort());
                List<WebSocketServerConfig.AccessToken> tokenConfig = this.webSocketConfig.getAccessTokens();
                for (WebSocketServerConfig.AccessToken obj : tokenConfig) {
                    this.tokens.put(obj.getTokenName(), obj.getTokenStr());
                }
            } else {
                log.error("webSocket server on starting the server", server.cause());
            }
        });
    }

    @Override
    public void stop() throws Exception {
        for (String deviceKey : this.wsClients.keySet()) {
            HashMap<String, String> deviceKeyObj = new HashMap<String, String>();
            deviceKeyObj.put("deviceKey", deviceKey);
            deviceKeyObj.put("type", "offline");
            this.executor.onReceive(null, "", JsonUtil.toJsonString(deviceKeyObj));
        }
        this.tokens.clear();
        this.httpServer.close(voidAsyncResult -> log.info("close webocket server..."));
    }

    private String getDeviceKey(String productKey, String deviceName) {
        return String.format("%s_%s", productKey, deviceName);
    }

    @Override
    public DeviceMessage send(DeviceMessage message) {
        ServerWebSocket wsClient = this.wsClients.get(message.getDeviceName());
        Object obj = message.getContent();
        if (!(obj instanceof Map)) {
            throw new BizException("message content is not Map");
        }
        String msgStr = JsonUtil.toJsonString((Object)obj);
        log.info("send msg payload:{}", (Object)msgStr);
        Future<Void> result = wsClient.writeTextMessage(msgStr);
        result.onFailure(e -> log.error("webSocket server send msg failed", e));
        return message;
    }
}

