/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core.http;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.util.Args;

public abstract class RequestMethod<T>
extends HttpEntityEnclosingRequestBase {
    private static Map<String, Class<? extends RequestMethod<?>>> factory = new ConcurrentHashMap();

    public T uri(String uri) {
        super.setURI(URI.create(uri));
        return (T)((Object)this);
    }

    public String getMethod() {
        return this.name();
    }

    protected abstract String name();

    public static RequestMethod<?> newInstance(String method) throws Exception {
        Class<RequestMethod<?>> k = factory.get(method);
        if (k == null) {
            throw new ClassNotFoundException(method);
        }
        return k.newInstance();
    }

    static {
        try {
            for (Class<?> k : RequestMethod.class.getDeclaredClasses()) {
                if (!RequestMethod.class.isAssignableFrom(k)) continue;
                factory.put(((RequestMethod)((Object)k.newInstance())).name(), k);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static class Trace
    extends RequestMethod<Trace> {
        @Override
        protected String name() {
            return "TRACE";
        }
    }

    public static class Options
    extends RequestMethod<Options> {
        @Override
        protected String name() {
            return "OPTIONS";
        }

        public Set<String> getAllowedMethods(HttpResponse response) {
            Args.notNull((Object)response, (String)"HTTP response");
            HeaderIterator it = response.headerIterator("Allow");
            HashSet<String> methods = new HashSet<String>();
            while (it.hasNext()) {
                HeaderElement[] elements;
                Header header = it.nextHeader();
                for (HeaderElement element : elements = header.getElements()) {
                    methods.add(element.getName());
                }
            }
            return methods;
        }
    }

    public static class Head
    extends RequestMethod<Head> {
        @Override
        protected String name() {
            return "HEAD";
        }
    }

    public static class Delete
    extends RequestMethod<Delete> {
        @Override
        protected String name() {
            return "DELETE";
        }
    }

    public static class Get
    extends RequestMethod<Get> {
        @Override
        protected String name() {
            return "GET";
        }
    }

    public static class Patch
    extends RequestMethod<Patch> {
        @Override
        protected String name() {
            return "PATCH";
        }
    }

    public static class Put
    extends RequestMethod<Put> {
        @Override
        protected String name() {
            return "PUT";
        }
    }

    public static class Post
    extends RequestMethod<Post> {
        @Override
        protected String name() {
            return "POST";
        }
    }
}

