/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.httpproxy.impl.ParseUtils;
import java.util.Date;
import java.util.List;

class HttpUtils {
    HttpUtils() {
    }

    static Boolean isChunked(MultiMap headers) {
        List<String> te = headers.getAll("transfer-encoding");
        if (te != null) {
            boolean chunked = false;
            for (String val : te) {
                if (val.equals("chunked")) {
                    chunked = true;
                    continue;
                }
                return null;
            }
            return chunked;
        }
        return false;
    }

    static Date dateHeader(MultiMap headers) {
        String dateHeader = headers.get(HttpHeaders.DATE);
        if (dateHeader == null) {
            List<String> warningHeaders = headers.getAll("warning");
            if (warningHeaders.size() > 0) {
                for (String warningHeader : warningHeaders) {
                    Date date = ParseUtils.parseWarningHeaderDate(warningHeader);
                    if (date == null) continue;
                    return date;
                }
            }
            return null;
        }
        return ParseUtils.parseHeaderDate(dateHeader);
    }
}

