/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.BooleanConverter;
import io.vertx.core.cli.converters.CharacterConverter;
import io.vertx.core.cli.converters.ConstructorBasedConverter;
import io.vertx.core.cli.converters.Converter;
import io.vertx.core.cli.converters.FromBasedConverter;
import io.vertx.core.cli.converters.FromStringBasedConverter;
import io.vertx.core.cli.converters.ValueOfBasedConverter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class Converters {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Converter<?>> WELL_KNOWN_CONVERTERS;

    public static <T> T create(Class<T> type2, String value) {
        if (type2.isPrimitive()) {
            type2 = Converters.wrap(type2);
        }
        return Converters.getConverter(type2).fromString(value);
    }

    public static <T> T create(String value, Converter<T> converter) {
        return converter.fromString(value);
    }

    private static <T> Class<T> wrap(Class<T> type2) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type2);
        return wrapped == null ? type2 : wrapped;
    }

    private static <T> Converter<T> getConverter(Class<T> type2) {
        if (WELL_KNOWN_CONVERTERS.containsKey(type2)) {
            return WELL_KNOWN_CONVERTERS.get(type2);
        }
        Converter<T> converter = ConstructorBasedConverter.getIfEligible(type2);
        if (converter != null) {
            return converter;
        }
        converter = ValueOfBasedConverter.getIfEligible(type2);
        if (converter != null) {
            return converter;
        }
        converter = FromBasedConverter.getIfEligible(type2);
        if (converter != null) {
            return converter;
        }
        converter = FromStringBasedConverter.getIfEligible(type2);
        if (converter != null) {
            return converter;
        }
        throw new NoSuchElementException("Cannot find a converter able to create instance of " + type2.getName());
    }

    public static <T> Converter<T> newInstance(Class<? extends Converter<T>> type2) throws IllegalArgumentException {
        try {
            return type2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create a new instance of " + type2.getName() + " - it requires an public constructor without argument", e);
        }
    }

    static {
        HashMap<Class<Object>, Class<Void>> primToWrap = new HashMap<Class<Object>, Class<Void>>(16);
        primToWrap.put(Boolean.TYPE, Boolean.class);
        primToWrap.put(Byte.TYPE, Byte.class);
        primToWrap.put(Character.TYPE, Character.class);
        primToWrap.put(Double.TYPE, Double.class);
        primToWrap.put(Float.TYPE, Float.class);
        primToWrap.put(Integer.TYPE, Integer.class);
        primToWrap.put(Long.TYPE, Long.class);
        primToWrap.put(Short.TYPE, Short.class);
        primToWrap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        HashMap<Class<String>, Converter<Object>> wellKnown = new HashMap<Class<String>, Converter<Object>>(16);
        wellKnown.put(Boolean.class, BooleanConverter.INSTANCE);
        wellKnown.put(Byte.class, Byte::parseByte);
        wellKnown.put(Character.class, CharacterConverter.INSTANCE);
        wellKnown.put(Double.class, Double::parseDouble);
        wellKnown.put(Float.class, Float::parseFloat);
        wellKnown.put(Integer.class, Integer::parseInt);
        wellKnown.put(Long.class, Long::parseLong);
        wellKnown.put(Short.class, Short::parseShort);
        wellKnown.put(String.class, value -> value);
        WELL_KNOWN_CONVERTERS = Collections.unmodifiableMap(wellKnown);
    }
}

