/*
 * Decompiled with CFR 0.152.
 */
package com.ctg.ag.sdk.core.http;

import com.ctg.ag.sdk.core.HttpClient;
import com.ctg.ag.sdk.core.constant.ParamPosition;
import com.ctg.ag.sdk.core.exception.SdkClientException;
import com.ctg.ag.sdk.core.http.ApacheIdleConnectionCleaner;
import com.ctg.ag.sdk.core.model.ApiCallBack;
import com.ctg.ag.sdk.core.model.BaseApiRequest;
import com.ctg.ag.sdk.core.model.BaseApiResponse;
import com.ctg.ag.sdk.core.model.BuilderParams;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient
extends HttpClient {
    private static final String EXT_PARAM_KEY_BUILDER = "apache.httpclient.builder";
    private static final int DEFAULT_THREAD_KEEP_ALIVE_TIME = 60;
    private ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private String host;
    private String scheme;

    public ApacheHttpClient(BuilderParams params) {
        super(params);
    }

    @Override
    protected void init(final BuilderParams params) {
        HttpClientBuilder builder = params.containsExtParam(EXT_PARAM_KEY_BUILDER) ? (HttpClientBuilder)params.getExtParam(EXT_PARAM_KEY_BUILDER) : HttpClientBuilder.create();
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout((int)params.getConnectionTimeoutMillis()).setCookieSpec("ignoreCookies").setSocketTimeout((int)params.getReadTimeoutMillis()).setConnectionRequestTimeout((int)params.getWriteTimeoutMillis()).build();
        builder.setDefaultRequestConfig(defaultConfig);
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) {
                    return true;
                }
            }).build();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        })).build();
        this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        this.connectionManager.setMaxTotal(params.getMaxRequests());
        this.connectionManager.setDefaultMaxPerRoute(params.getMaxRequestsPerHost());
        this.connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Charset.forName("utf-8")).build());
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        ApacheIdleConnectionCleaner.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, params.getMaxIdleTimeMillis());
        this.executorService = params.getExecutorService() == null ? new ThreadPoolExecutor(0, params.getMaxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DeafultAsyncThreadFactory()) : params.getExecutorService();
        if (params.getKeepAliveDurationMillis() > 0L) {
            builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                    if (duration > 0L && duration < params.getKeepAliveDurationMillis()) {
                        return duration;
                    }
                    return params.getKeepAliveDurationMillis();
                }
            });
        }
        this.httpClient = builder.build();
        this.host = params.getHost();
        this.scheme = params.getScheme().getValue();
    }

    private HttpUriRequest parseToHttpRequest(BaseApiRequest apiReq) {
        RequestBuilder builder = RequestBuilder.create((String)apiReq.getMethod().getName());
        try {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(apiReq.getScheme() != null ? apiReq.getScheme() : this.scheme);
            String host = apiReq.getHost() != null ? apiReq.getHost() : this.host;
            String[] split = host.split("/");
            uriBuilder.setHost(split[0]);
            apiReq.getGlobalParam().put("Host", uriBuilder.getHost());
            Iterator<Map.Entry<String, List<String>>> path = (split.length > 1 ? split[1] : "") + apiReq.getPath();
            if (!((String)((Object)path)).startsWith("/")) {
                path = "/" + (String)((Object)path);
            }
            uriBuilder.setPath((String)((Object)path));
            Map<String, List<String>> query = apiReq.getParam(ParamPosition.QUERY);
            if (query != null) {
                for (Map.Entry<String, List<String>> entry : query.entrySet()) {
                    for (String s : entry.getValue()) {
                        uriBuilder.addParameter(entry.getKey(), s);
                    }
                }
            }
            builder.setUri(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new SdkClientException("build http request uri failed", e);
        }
        EntityBuilder bodyBuilder = EntityBuilder.create();
        bodyBuilder.setContentType(apiReq.getMethod().getContentType());
        Map<String, List<String>> body = apiReq.getParam(ParamPosition.BODY);
        if (body != null && body.size() != 0) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, List<String>> entry : body.entrySet()) {
                for (String s : (List)entry.getValue()) {
                    paramList.add(new BasicNameValuePair(entry.getKey(), s));
                }
            }
            bodyBuilder.setParameters(paramList);
            builder.setEntity(bodyBuilder.build());
        } else if (apiReq.getBody() != null) {
            bodyBuilder.setBinary(apiReq.getBody());
            builder.setEntity(bodyBuilder.build());
        }
        Map<String, List<String>> header = apiReq.getParam(ParamPosition.HEAD);
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            for (String s : entry.getValue()) {
                builder.addHeader(entry.getKey(), s);
            }
        }
        Map<String, String> global = apiReq.getGlobalParam();
        for (Map.Entry<String, String> entry : global.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private BaseApiResponse parseToApiResponse(HttpResponse httpResponse, BaseApiResponse result) throws IOException {
        Header[] contentType;
        result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        if (httpResponse.getEntity() != null) {
            contentType = httpResponse.getEntity().getContentType();
            if (contentType != null) {
                result.setContentType(contentType.getValue());
            }
            result.setBody(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
        } else {
            contentType = httpResponse.getFirstHeader("Content-Type");
            result.setContentType(contentType.getValue());
        }
        result.setHeaders(new HashMap<String, String>());
        for (Header header : httpResponse.getAllHeaders()) {
            result.getHeaders().put(header.getName(), header.getValue());
        }
        Header message = httpResponse.getFirstHeader("x-ag-message");
        if (message != null) {
            result.setMessage(message.getValue());
        } else {
            result.setMessage(httpResponse.getStatusLine().getReasonPhrase());
        }
        return result;
    }

    @Override
    public final BaseApiResponse syncInvoke(BaseApiRequest apiRequest) {
        HttpUriRequest httpRequest = this.parseToHttpRequest(apiRequest);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute(httpRequest);
            BaseApiResponse response = apiRequest.newResponse();
            BaseApiResponse baseApiResponse = this.parseToApiResponse((HttpResponse)httpResponse, response);
            return baseApiResponse;
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public <REQ extends BaseApiRequest, RESP extends BaseApiResponse> Future<RESP> asyncInvoke(final REQ request, final ApiCallBack<REQ, RESP> callback) {
        return this.executorService.submit(new Callable<RESP>(){

            @Override
            public RESP call() throws Exception {
                BaseApiResponse result;
                try {
                    result = ApacheHttpClient.this.syncInvoke(request);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onFailure(request, e);
                    }
                    throw e;
                }
                if (callback != null) {
                    callback.onResponse(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        ApacheIdleConnectionCleaner.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
        this.connectionManager.shutdown();
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class DeafultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private DeafultAsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Telecom API Gateway Java SDK Async ThreadPool - " + this.counter.incrementAndGet());
        }
    }
}

