/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CSRFHandlerImpl
implements CSRFHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CSRFHandlerImpl.class);
    private final VertxContextPRNG random;
    private final Mac mac;
    private boolean nagHttps;
    private String cookieName = "XSRF-TOKEN";
    private String cookiePath = "/";
    private String headerName = "X-XSRF-TOKEN";
    private long timeout = 1800000L;
    private Origin origin;
    private boolean httpOnly;

    public CSRFHandlerImpl(Vertx vertx, String secret) {
        try {
            if (secret.length() <= 8) {
                LOG.warn("CSRF secret is very short (<= 8 bytes)");
            }
            this.random = VertxContextPRNG.current((Vertx)vertx);
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CSRFHandler setOrigin(String origin) {
        this.origin = Origin.parse(origin);
        return this;
    }

    @Override
    public CSRFHandler setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    @Override
    public CSRFHandler setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    @Override
    public CSRFHandler setCookieHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public CSRFHandler setHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    @Override
    public CSRFHandler setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public CSRFHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    private String generateAndStoreToken(RoutingContext ctx) {
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        String saltPlusToken = Codec.base64UrlEncode((byte[])salt) + "." + System.currentTimeMillis();
        String signature = Codec.base64UrlEncode((byte[])this.mac.doFinal(saltPlusToken.getBytes(StandardCharsets.US_ASCII)));
        String token = saltPlusToken + "." + signature;
        ctx.response().addCookie(Cookie.cookie(this.cookieName, token).setPath(this.cookiePath).setHttpOnly(this.httpOnly).setSameSite(CookieSameSite.STRICT));
        Session session = ctx.session();
        if (session != null) {
            session.put(this.headerName, session.id() + "/" + token);
        }
        return token;
    }

    private String getTokenFromSession(RoutingContext ctx) {
        int idx;
        Session session = ctx.session();
        if (session == null) {
            return null;
        }
        String sessionToken = (String)session.get(this.headerName);
        if (sessionToken != null && (idx = sessionToken.indexOf(47)) != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
            return sessionToken.substring(idx + 1);
        }
        return null;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static long parseLong(String s) {
        if (CSRFHandlerImpl.isBlank(s)) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            LOG.trace("Invalid Token format", e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidRequest(RoutingContext ctx) {
        long ts;
        String[] tokens;
        Object challenge;
        byte[] cookieBytes;
        Cookie cookie = ctx.request().getCookie(this.cookieName);
        String header = ctx.request().getHeader(this.headerName);
        if (header == null) {
            if (!((RoutingContextInternal)ctx).seenHandler(2)) {
                ctx.fail(new IllegalStateException("BodyHandler is required to process POST requests"));
                return false;
            }
            header = ctx.request().getFormAttribute(this.headerName);
        }
        if (header == null || cookie == null || CSRFHandlerImpl.isBlank(header)) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header/Form is absent/empty"));
            return false;
        }
        String cookieValue = cookie.getValue();
        if (cookieValue == null || CSRFHandlerImpl.isBlank(cookieValue)) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header/Form is absent/empty"));
            return false;
        }
        byte[] headerBytes = header.getBytes(StandardCharsets.UTF_8);
        if (!MessageDigest.isEqual(headerBytes, cookieBytes = cookieValue.getBytes(StandardCharsets.UTF_8))) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header and via Cookie are not equal"));
            return false;
        }
        Session session = ctx.session();
        if (session != null) {
            String sessionToken = (String)session.get(this.headerName);
            if (sessionToken == null) {
                ctx.fail(403, new IllegalArgumentException("No Token has been added to the session"));
                return false;
            }
            int idx = sessionToken.indexOf(47);
            if (idx != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
                challenge = sessionToken.substring(idx + 1);
                if (!MessageDigest.isEqual(((String)challenge).getBytes(StandardCharsets.UTF_8), headerBytes)) {
                    ctx.fail(403, new IllegalArgumentException("Token has been used or is outdated"));
                    return false;
                }
            } else {
                ctx.fail(403, new IllegalArgumentException("Token has been issued for a different session"));
                return false;
            }
        }
        if ((tokens = header.split("\\.")).length != 3) {
            ctx.fail(403);
            return false;
        }
        byte[] saltPlusToken = (tokens[0] + "." + tokens[1]).getBytes(StandardCharsets.US_ASCII);
        challenge = this.mac;
        synchronized (challenge) {
            saltPlusToken = this.mac.doFinal(saltPlusToken);
        }
        byte[] signature = Codec.base64UrlEncode((byte[])saltPlusToken).getBytes(StandardCharsets.US_ASCII);
        if (!MessageDigest.isEqual(signature, tokens[2].getBytes(StandardCharsets.US_ASCII))) {
            ctx.fail(403, new IllegalArgumentException("Token signature does not match"));
            return false;
        }
        if (session != null) {
            session.remove(this.headerName);
        }
        if ((ts = CSRFHandlerImpl.parseLong(tokens[1])) == -1L) {
            ctx.fail(403);
            return false;
        }
        if (System.currentTimeMillis() > ts + this.timeout) {
            ctx.fail(403, new IllegalArgumentException("CSRF validity expired"));
            return false;
        }
        return true;
    }

    @Override
    public void handle(RoutingContext ctx) {
        String uri;
        if (this.nagHttps && (uri = ctx.request().absoluteURI()) != null && !uri.startsWith("https:")) {
            LOG.trace("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        HttpMethod method = ctx.request().method();
        Session session = ctx.session();
        if (!Origin.check(this.origin, ctx)) {
            ctx.fail(403, new IllegalStateException("Invalid Origin"));
            return;
        }
        switch (method.name()) {
            case "GET": {
                String[] parts;
                long ts;
                String sessionToken;
                String token = session == null ? this.generateAndStoreToken(ctx) : ((sessionToken = this.getTokenFromSession(ctx)) == null ? this.generateAndStoreToken(ctx) : ((ts = CSRFHandlerImpl.parseLong((parts = sessionToken.split("\\."))[1])) == -1L ? this.generateAndStoreToken(ctx) : (System.currentTimeMillis() <= ts + this.timeout ? sessionToken : this.generateAndStoreToken(ctx))));
                ctx.put(this.headerName, token);
                ctx.next();
                break;
            }
            case "POST": 
            case "PUT": 
            case "DELETE": 
            case "PATCH": {
                if (!this.isValidRequest(ctx)) break;
                String token = this.generateAndStoreToken(ctx);
                ctx.put(this.headerName, token);
                ctx.next();
                break;
            }
            default: {
                ctx.next();
            }
        }
    }
}

