/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.util.concurrent.TimeUnit;

@DataObject
public class MqttServerOptions
extends NetServerOptions {
    public static final int DEFAULT_PORT = 1883;
    public static final int DEFAULT_TLS_PORT = 8883;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = -1;
    public static final int DEFAULT_TIMEOUT_ON_CONNECT = 90;
    public static final String MQTT_SUBPROTOCOL_CSV_LIST = "mqtt, mqttv3.1, mqttv3.1.1";
    private int maxMessageSize;
    private boolean isAutoClientId;
    private int timeoutOnConnect;
    private boolean useWebSocket;

    public MqttServerOptions() {
        this.setPort(1883);
        this.maxMessageSize = -1;
        this.isAutoClientId = true;
        this.timeoutOnConnect = 90;
    }

    public MqttServerOptions(JsonObject json) {
        super(json);
        this.setPort(json.getInteger("port", 1883));
        this.maxMessageSize = json.getInteger("maxMessageSize", -1);
        this.isAutoClientId = json.getBoolean("isAutoClientId", true);
        this.timeoutOnConnect = json.getInteger("timeoutOnConnect", 90);
        if (this.maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require(this.getReceiveBufferSize() >= this.maxMessageSize, "Receiver buffer size can't be lower than max message size");
        }
    }

    public MqttServerOptions(MqttServerOptions other) {
        super(other);
    }

    @Override
    public MqttServerOptions setPort(int port) {
        super.setPort(port);
        return this;
    }

    @Override
    public MqttServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    @Override
    public MqttServerOptions setClientAuth(ClientAuth clientAuth) {
        super.setClientAuth(clientAuth);
        return this;
    }

    @Override
    public MqttServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public MqttServerOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    @Override
    public MqttServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public MqttServerOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public MqttServerOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    @Override
    public MqttServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    @Override
    public MqttServerOptions setReceiveBufferSize(int receiveBufferSize) {
        if (this.maxMessageSize > 0 && receiveBufferSize > 0) {
            Arguments.require(receiveBufferSize >= this.maxMessageSize, "Receiver buffer size can't be lower than max message size");
        }
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public MqttServerOptions setSni(boolean sni) {
        super.setSni(sni);
        return this;
    }

    public MqttServerOptions setMaxMessageSize(int maxMessageSize) {
        Arguments.require(maxMessageSize > 0 || maxMessageSize == -1, "maxMessageSize must be > 0");
        if (maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require(this.getReceiveBufferSize() >= maxMessageSize, "Receiver buffer size can't be lower than max message size");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public MqttServerOptions setAutoClientId(boolean isAutoClientId) {
        this.isAutoClientId = isAutoClientId;
        return this;
    }

    public boolean isAutoClientId() {
        return this.isAutoClientId;
    }

    public MqttServerOptions setTimeoutOnConnect(int timeoutOnConnect) {
        this.timeoutOnConnect = timeoutOnConnect;
        return this;
    }

    @Override
    public MqttServerOptions setUseProxyProtocol(boolean useProxyProtocol) {
        super.setUseProxyProtocol(useProxyProtocol);
        return this;
    }

    @Override
    public boolean isUseProxyProtocol() {
        return super.isUseProxyProtocol();
    }

    @Override
    public long getProxyProtocolTimeout() {
        return super.getProxyProtocolTimeout();
    }

    @Override
    public MqttServerOptions setProxyProtocolTimeout(long proxyProtocolTimeout) {
        super.setProxyProtocolTimeout(proxyProtocolTimeout);
        return this;
    }

    @Override
    public MqttServerOptions setProxyProtocolTimeoutUnit(TimeUnit proxyProtocolTimeoutUnit) {
        super.setProxyProtocolTimeoutUnit(proxyProtocolTimeoutUnit);
        return this;
    }

    @Override
    public TimeUnit getProxyProtocolTimeoutUnit() {
        return super.getProxyProtocolTimeoutUnit();
    }

    public int timeoutOnConnect() {
        return this.timeoutOnConnect;
    }

    public MqttServerOptions setUseWebSocket(boolean useWebSocket) {
        this.useWebSocket = useWebSocket;
        return this;
    }

    public boolean isUseWebSocket() {
        return this.useWebSocket;
    }
}

