/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.Transport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import io.vertx.ext.web.handler.sockjs.impl.StringEscapeUtils;
import io.vertx.ext.web.handler.sockjs.impl.TransportListener;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;

class BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTransport.class);
    protected final Vertx vertx;
    protected final LocalMap<String, SockJSSession> sessions;
    protected SockJSHandlerOptions options;
    static final String COMMON_PATH_ELEMENT_RE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";

    public BaseTransport(Vertx vertx, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options) {
        this.vertx = vertx;
        this.sessions = sessions;
        this.options = options;
    }

    protected SockJSSession getSession(RoutingContext rc, SockJSHandlerOptions options, String sessionID, Handler<SockJSSocket> sockHandler) {
        return this.sessions.computeIfAbsent(sessionID, s -> new SockJSSession(this.vertx, this.sessions, rc, (String)s, options, sockHandler));
    }

    protected void sendInvalidJSON(HttpServerResponse response) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Broken JSON");
        }
        response.setStatusCode(500);
        response.end("Broken JSON encoding.");
    }

    protected String escapeForJavaScript(String str) {
        try {
            str = StringEscapeUtils.escapeJavaScript(str);
        }
        catch (Exception e) {
            LOG.error("Failed to escape", e);
            str = null;
        }
        return str;
    }

    static void setJSESSIONID(SockJSHandlerOptions options, RoutingContext rc) {
        String cookies = rc.request().getHeader(HttpHeaders.COOKIE);
        if (options.isInsertJSESSIONID()) {
            if (cookies != null) {
                String[] parts = cookies.contains(";") ? cookies.split(";") : new String[]{cookies};
                for (String part : parts) {
                    if (!part.startsWith("JSESSIONID")) continue;
                    cookies = part + "; path=/";
                    break;
                }
            }
            if (cookies == null) {
                cookies = "JSESSIONID=dummy; path=/";
            }
            rc.response().putHeader(HttpHeaders.SET_COOKIE, (CharSequence)cookies);
        }
    }

    static void setCORS(RoutingContext rc) {
        if (!((RoutingContextInternal)rc).seenHandler(4)) {
            HttpServerRequest req = rc.request();
            String origin = req.getHeader(HttpHeaders.ORIGIN);
            if (origin == null) {
                origin = "*";
            }
            req.response().headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
            if ("*".equals(origin)) {
                req.response().headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"false");
            } else {
                req.response().headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
            }
            String hdr = req.headers().get(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS);
            if (hdr != null) {
                req.response().headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)hdr);
            }
        }
    }

    static Handler<RoutingContext> createInfoHandler(final SockJSHandlerOptions options, final VertxContextPRNG prng) {
        long offset = 0x80000000L;
        return new Handler<RoutingContext>(){
            final boolean websocket;
            {
                this.websocket = !options.getDisabledTransports().contains(Transport.WEBSOCKET.toString());
            }

            @Override
            public void handle(RoutingContext rc) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("In Info handler");
                }
                rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(rc);
                JsonObject json = new JsonObject();
                json.put("websocket", this.websocket);
                json.put("cookie_needed", options.isInsertJSESSIONID());
                json.put("origins", new JsonArray().add("*:*"));
                json.put("entropy", 0x80000000L + (long)prng.nextInt());
                BaseTransport.setCORS(rc);
                rc.response().end(json.encode());
            }
        };
    }

    static void setNoCacheHeaders(RoutingContext rc) {
        rc.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store, no-cache, no-transform, must-revalidate, max-age=0");
    }

    static Handler<RoutingContext> createCORSOptionsHandler(SockJSHandlerOptions options, String methods) {
        return rc -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("In CORS options handler");
            }
            rc.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"public,max-age=31536000");
            long oneYearSeconds = 31536000L;
            long oneYearms = oneYearSeconds * 1000L;
            String expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date(System.currentTimeMillis() + oneYearms));
            rc.response().putHeader(HttpHeaders.EXPIRES, (CharSequence)expires).putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)methods).putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(oneYearSeconds));
            BaseTransport.setCORS(rc);
            BaseTransport.setJSESSIONID(options, rc);
            rc.response().setStatusCode(204);
            rc.response().end();
        };
    }

    static MultiMap removeCookieHeaders(MultiMap headers) {
        String cookieHeader = headers.get(HttpHeaders.COOKIE);
        if (cookieHeader != null) {
            headers.remove(HttpHeaders.COOKIE);
            Set nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader);
            for (Cookie cookie : nettyCookies) {
                if (!cookie.name().equals("JSESSIONID")) continue;
                headers.add(HttpHeaders.COOKIE, (CharSequence)ServerCookieEncoder.STRICT.encode(cookie));
                break;
            }
        }
        return headers;
    }

    protected static abstract class BaseListener
    implements TransportListener {
        protected final RoutingContext rc;
        protected final SockJSSession session;
        protected boolean closed;

        protected BaseListener(RoutingContext rc, SockJSSession session) {
            this.rc = rc;
            this.session = session;
        }

        protected void addCloseHandler(HttpServerResponse resp, SockJSSession session) {
            resp.closeHandler(v -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Connection closed (from client?), closing session");
                }
                session.shutdown();
                this.closed = true;
            });
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.close();
        }
    }
}

