/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Array;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;

class JavaArray
extends LuaUserdata {
    static final LuaValue LENGTH = JavaArray.valueOf("length");
    static final LuaTable array_metatable = new LuaTable();

    JavaArray(Object object) {
        super(object);
        this.setmetatable(array_metatable);
    }

    public LuaValue get(LuaValue luaValue) {
        if (luaValue.equals(LENGTH)) {
            return JavaArray.valueOf(Array.getLength(this.m_instance));
        }
        if (luaValue.isint()) {
            int n = luaValue.toint() - 1;
            return n >= 0 && n < Array.getLength(this.m_instance) ? CoerceJavaToLua.coerce(Array.get(this.m_instance, luaValue.toint() - 1)) : NIL;
        }
        return super.get(luaValue);
    }

    public void set(LuaValue luaValue, LuaValue luaValue2) {
        if (luaValue.isint()) {
            int n = luaValue.toint() - 1;
            if (n >= 0 && n < Array.getLength(this.m_instance)) {
                Array.set(this.m_instance, n, CoerceLuaToJava.coerce(luaValue2, this.m_instance.getClass().getComponentType()));
            } else if (this.m_metatable == null || !JavaArray.settable(this, luaValue, luaValue2)) {
                JavaArray.error("array index out of bounds");
            }
        } else {
            super.set(luaValue, luaValue2);
        }
    }

    static {
        array_metatable.rawset(LuaValue.LEN, (LuaValue)new LenFunction());
    }

    private static final class LenFunction
    extends OneArgFunction {
        private LenFunction() {
        }

        public LuaValue call(LuaValue luaValue) {
            return LuaValue.valueOf(Array.getLength(((LuaUserdata)luaValue).m_instance));
        }
    }
}

